/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import java.io.IOException;
import org.rrd4j.core.RrdByteArrayBackend;

public class RrdBerkeleyDbBackend
extends RrdByteArrayBackend {
    private final Database rrdDatabase;
    private volatile boolean dirty = false;

    protected RrdBerkeleyDbBackend(String string, Database database) {
        super(string);
        this.rrdDatabase = database;
    }

    protected RrdBerkeleyDbBackend(byte[] byArray, String string, Database database) {
        super(string);
        this.buffer = byArray;
        this.rrdDatabase = database;
    }

    @Override
    protected synchronized void write(long l, byte[] byArray) throws IOException {
        super.write(l, byArray);
        this.dirty = true;
    }

    @Override
    public void close() throws IOException {
        if (this.dirty) {
            DatabaseEntry databaseEntry = new DatabaseEntry(this.getPath().getBytes("UTF-8"));
            DatabaseEntry databaseEntry2 = new DatabaseEntry(this.buffer);
            try {
                this.rrdDatabase.put(null, databaseEntry, databaseEntry2);
            }
            catch (DatabaseException databaseException) {
                throw new IOException(databaseException.getMessage());
            }
        }
    }
}

