/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.io.IOException;
import java.io.PrintStream;
import org.rrd4j.core.jrrd.RRDFile;
import org.rrd4j.core.jrrd.UnivalArray;

public class CDPStatusBlock {
    final long offset;
    final long size;
    final int unknownDatapoints;
    final double value;
    final double secondary_value;
    final double primary_value;

    CDPStatusBlock(RRDFile rRDFile) throws IOException {
        this.offset = rRDFile.getFilePointer();
        UnivalArray univalArray = rRDFile.getUnivalArray(10);
        this.value = univalArray.getDouble(cdp_par_en.CDP_val);
        this.unknownDatapoints = (int)univalArray.getDouble(cdp_par_en.CDP_unkn_pdp_cnt);
        this.primary_value = univalArray.getDouble(cdp_par_en.CDP_primary_val);
        this.secondary_value = univalArray.getDouble(cdp_par_en.CDP_secondary_val);
        this.size = rRDFile.getFilePointer() - this.offset;
    }

    public int getUnknownDatapoints() {
        return this.unknownDatapoints;
    }

    public double getValue() {
        return this.value;
    }

    void toXml(PrintStream printStream) {
        printStream.print("\t\t\t<ds><value> ");
        printStream.print(this.value);
        printStream.print(" </value>  <unknown_datapoints> ");
        printStream.print(this.unknownDatapoints);
        printStream.println(" </unknown_datapoints></ds>");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[CDPStatusBlock: OFFSET=0x");
        stringBuilder.append(Long.toHexString(this.offset));
        stringBuilder.append(", SIZE=0x");
        stringBuilder.append(Long.toHexString(this.size));
        stringBuilder.append(", unknownDatapoints=");
        stringBuilder.append(this.unknownDatapoints);
        stringBuilder.append(", value=");
        stringBuilder.append(this.value);
        stringBuilder.append(", primaryValue=");
        stringBuilder.append(this.primary_value);
        stringBuilder.append(", secondaryValue=");
        stringBuilder.append(this.secondary_value);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static enum cdp_par_en {
        CDP_val,
        CDP_unkn_pdp_cnt,
        CDP_hw_intercept,
        CDP_hw_last_intercept,
        CDP_hw_slope,
        CDP_hw_last_slope,
        CDP_null_count,
        CDP_last_null_count,
        CDP_primary_val,
        CDP_secondary_val;

    }
}

