/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.util.Map;
import org.rrd4j.data.LinearInterpolator;
import org.rrd4j.data.Plottable;

public class DataChunk {
    private static final String NEWLINE = System.getProperty("line.separator");
    private final long startTime;
    final int start;
    final int end;
    private final long step;
    final int dsCount;
    final double[][] data;
    private final int rows;
    private final Map<String, Integer> nameindex;

    DataChunk(Map<String, Integer> map, long l, int n, int n2, long l2, int n3, int n4) {
        this.nameindex = map;
        this.startTime = l;
        this.start = n;
        this.end = n2;
        this.step = l2;
        this.dsCount = n3;
        this.rows = n4;
        this.data = new double[n4][n3];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        long l = this.startTime;
        int n = 0;
        while (n < this.rows) {
            stringBuilder.append(l);
            stringBuilder.append(": ");
            for (int i = 0; i < this.dsCount; ++i) {
                stringBuilder.append(this.data[n][i]);
                stringBuilder.append(" ");
            }
            stringBuilder.append(NEWLINE);
            ++n;
            l += this.step;
        }
        return stringBuilder.toString();
    }

    public double[][] getData() {
        return this.data;
    }

    public Plottable toPlottable(String string) {
        Integer n = this.nameindex.get(string);
        if (n == null) {
            throw new RuntimeException("datasource not not found: " + string);
        }
        long[] lArray = new long[this.rows];
        double[] dArray = new double[this.rows];
        long l = this.startTime;
        int n2 = 0;
        while (n2 < this.rows) {
            lArray[n2] = l;
            dArray[n2] = this.data[n2][n];
            ++n2;
            l += this.step;
        }
        return new LinearInterpolator(lArray, dArray);
    }
}

