/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.io.IOException;
import java.io.PrintStream;
import java.text.NumberFormat;
import org.rrd4j.core.jrrd.DataSourceType;
import org.rrd4j.core.jrrd.PDPStatusBlock;
import org.rrd4j.core.jrrd.RRDFile;
import org.rrd4j.core.jrrd.UnivalArray;

public class DataSource {
    private long offset;
    private long size;
    private String name;
    private DataSourceType type;
    private int minimumHeartbeat;
    private double minimum;
    private double maximum;
    private PDPStatusBlock pdpStatusBlock;

    DataSource(RRDFile rRDFile) throws IOException {
        this.offset = rRDFile.getFilePointer();
        this.name = rRDFile.readString(20);
        this.type = DataSourceType.valueOf(rRDFile.readString(20).toUpperCase());
        rRDFile.align(8);
        UnivalArray univalArray = rRDFile.getUnivalArray(10);
        this.minimumHeartbeat = (int)univalArray.getLong(ds_param_en.DS_mrhb_cnt);
        this.minimum = univalArray.getDouble(ds_param_en.DS_min_val);
        this.maximum = univalArray.getDouble(ds_param_en.DS_max_val);
        this.size = rRDFile.getFilePointer() - this.offset;
    }

    void loadPDPStatusBlock(RRDFile rRDFile) throws IOException {
        this.pdpStatusBlock = new PDPStatusBlock(rRDFile);
    }

    public PDPStatusBlock getPDPStatusBlock() {
        return this.pdpStatusBlock;
    }

    public int getMinimumHeartbeat() {
        return this.minimumHeartbeat;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public DataSourceType getType() {
        return this.type;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public String getName() {
        return this.name;
    }

    void printInfo(PrintStream printStream, NumberFormat numberFormat) {
        StringBuilder stringBuilder = new StringBuilder("ds[");
        stringBuilder.append(this.name);
        printStream.print(stringBuilder);
        printStream.print("].type = \"");
        printStream.print((Object)this.type);
        printStream.println("\"");
        printStream.print(stringBuilder);
        printStream.print("].minimal_heartbeat = ");
        printStream.println(this.minimumHeartbeat);
        printStream.print(stringBuilder);
        printStream.print("].min = ");
        printStream.println(Double.isNaN(this.minimum) ? "NaN" : numberFormat.format(this.minimum));
        printStream.print(stringBuilder);
        printStream.print("].max = ");
        printStream.println(Double.isNaN(this.maximum) ? "NaN" : numberFormat.format(this.maximum));
        printStream.print(stringBuilder);
        printStream.print("].last_ds = ");
        printStream.println(this.pdpStatusBlock.lastReading);
        printStream.print(stringBuilder);
        printStream.print("].value = ");
        double d = this.pdpStatusBlock.value;
        printStream.println(Double.isNaN(d) ? "NaN" : numberFormat.format(d));
        printStream.print(stringBuilder);
        printStream.print("].unknown_sec = ");
        printStream.println(this.pdpStatusBlock.unknownSeconds);
    }

    void toXml(PrintStream printStream) {
        printStream.println("\t<ds>");
        printStream.print("\t\t<name> ");
        printStream.print(this.name);
        printStream.println(" </name>");
        printStream.print("\t\t<type> ");
        printStream.print((Object)this.type);
        printStream.println(" </type>");
        printStream.print("\t\t<minimal_heartbeat> ");
        printStream.print(this.minimumHeartbeat);
        printStream.println(" </minimal_heartbeat>");
        printStream.print("\t\t<min> ");
        printStream.print(this.minimum);
        printStream.println(" </min>");
        printStream.print("\t\t<max> ");
        printStream.print(this.maximum);
        printStream.println(" </max>");
        printStream.println();
        printStream.println("\t\t<!-- PDP Status -->");
        printStream.print("\t\t<last_ds> ");
        printStream.print(this.pdpStatusBlock.lastReading);
        printStream.println(" </last_ds>");
        printStream.print("\t\t<value> ");
        printStream.print(this.pdpStatusBlock.value);
        printStream.println(" </value>");
        printStream.print("\t\t<unknown_sec> ");
        printStream.print(this.pdpStatusBlock.unknownSeconds);
        printStream.println(" </unknown_sec>");
        printStream.println("\t</ds>");
        printStream.println();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[DataSource: OFFSET=0x");
        stringBuilder.append(Long.toHexString(this.offset));
        stringBuilder.append(", SIZE=0x");
        stringBuilder.append(Long.toHexString(this.size));
        stringBuilder.append(", name=");
        stringBuilder.append(this.name);
        stringBuilder.append(", type=");
        stringBuilder.append(this.type.toString());
        stringBuilder.append(", minHeartbeat=");
        stringBuilder.append(this.minimumHeartbeat);
        stringBuilder.append(", min=");
        stringBuilder.append(this.minimum);
        stringBuilder.append(", max=");
        stringBuilder.append(this.maximum);
        stringBuilder.append("]");
        stringBuilder.append("\n\t\t");
        stringBuilder.append(this.pdpStatusBlock.toString());
        return stringBuilder.toString();
    }

    private static enum ds_param_en {
        DS_mrhb_cnt,
        DS_min_val,
        DS_max_val,
        DS_cde;

    }
}

