/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.data;

import java.util.Calendar;
import java.util.StringTokenizer;
import org.rrd4j.core.Util;
import org.rrd4j.data.DataProcessor;

class RpnCalculator {
    private static final byte TKN_VAR = 0;
    private static final byte TKN_NUM = 1;
    private static final byte TKN_PLUS = 2;
    private static final byte TKN_MINUS = 3;
    private static final byte TKN_MULT = 4;
    private static final byte TKN_DIV = 5;
    private static final byte TKN_MOD = 6;
    private static final byte TKN_SIN = 7;
    private static final byte TKN_COS = 8;
    private static final byte TKN_LOG = 9;
    private static final byte TKN_EXP = 10;
    private static final byte TKN_SQRT = 11;
    private static final byte TKN_ATAN = 12;
    private static final byte TKN_ATAN2 = 13;
    private static final byte TKN_FLOOR = 14;
    private static final byte TKN_CEIL = 15;
    private static final byte TKN_DEG2RAD = 16;
    private static final byte TKN_RAD2DEG = 17;
    private static final byte TKN_ROUND = 18;
    private static final byte TKN_POW = 19;
    private static final byte TKN_ABS = 20;
    private static final byte TKN_RANDOM = 21;
    private static final byte TKN_LT = 22;
    private static final byte TKN_LE = 23;
    private static final byte TKN_GT = 24;
    private static final byte TKN_GE = 25;
    private static final byte TKN_EQ = 26;
    private static final byte TKN_NE = 27;
    private static final byte TKN_IF = 28;
    private static final byte TKN_MIN = 29;
    private static final byte TKN_MAX = 30;
    private static final byte TKN_LIMIT = 31;
    private static final byte TKN_DUP = 32;
    private static final byte TKN_EXC = 33;
    private static final byte TKN_POP = 34;
    private static final byte TKN_UN = 35;
    private static final byte TKN_UNKN = 36;
    private static final byte TKN_NOW = 37;
    private static final byte TKN_TIME = 38;
    private static final byte TKN_PI = 39;
    private static final byte TKN_E = 40;
    private static final byte TKN_AND = 41;
    private static final byte TKN_OR = 42;
    private static final byte TKN_XOR = 43;
    private static final byte TKN_PREV = 44;
    private static final byte TKN_INF = 45;
    private static final byte TKN_NEGINF = 46;
    private static final byte TKN_STEP = 47;
    private static final byte TKN_YEAR = 48;
    private static final byte TKN_MONTH = 49;
    private static final byte TKN_DATE = 50;
    private static final byte TKN_HOUR = 51;
    private static final byte TKN_MINUTE = 52;
    private static final byte TKN_SECOND = 53;
    private static final byte TKN_WEEK = 54;
    private static final byte TKN_SIGN = 55;
    private static final byte TKN_RND = 56;
    private final String rpnExpression;
    private final String sourceName;
    private final DataProcessor dataProcessor;
    private final Token[] tokens;
    private final RpnStack stack = new RpnStack();
    private final double[] calculatedValues;
    private final long[] timestamps;
    private final double timeStep;

    RpnCalculator(String string, String string2, DataProcessor dataProcessor) {
        this.rpnExpression = string;
        this.sourceName = string2;
        this.dataProcessor = dataProcessor;
        this.timestamps = dataProcessor.getTimestamps();
        this.timeStep = this.timestamps[1] - this.timestamps[0];
        this.calculatedValues = new double[this.timestamps.length];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        this.tokens = new Token[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.tokens[n] = this.createToken(stringTokenizer.nextToken());
            ++n;
        }
    }

    private Token createToken(String string) {
        Token token = new Token();
        if (Util.isDouble(string)) {
            token.id = 1;
            token.number = Util.parseDouble(string);
        } else if (string.equals("+")) {
            token.id = (byte)2;
        } else if (string.equals("-")) {
            token.id = (byte)3;
        } else if (string.equals("*")) {
            token.id = (byte)4;
        } else if (string.equals("/")) {
            token.id = (byte)5;
        } else if (string.equals("%")) {
            token.id = (byte)6;
        } else if (string.equals("SIN")) {
            token.id = (byte)7;
        } else if (string.equals("COS")) {
            token.id = (byte)8;
        } else if (string.equals("LOG")) {
            token.id = (byte)9;
        } else if (string.equals("EXP")) {
            token.id = (byte)10;
        } else if (string.equals("ATAN")) {
            token.id = (byte)12;
        } else if (string.equals("ATAN2")) {
            token.id = (byte)13;
        } else if (string.equals("FLOOR")) {
            token.id = (byte)14;
        } else if (string.equals("CEIL")) {
            token.id = (byte)15;
        } else if (string.equals("DEG2RAD")) {
            token.id = (byte)16;
        } else if (string.equals("RAD2DEG")) {
            token.id = (byte)17;
        } else if (string.equals("ROUND")) {
            token.id = (byte)18;
        } else if (string.equals("POW")) {
            token.id = (byte)19;
        } else if (string.equals("ABS")) {
            token.id = (byte)20;
        } else if (string.equals("SQRT")) {
            token.id = (byte)11;
        } else if (string.equals("RANDOM")) {
            token.id = (byte)21;
        } else if (string.equals("LT")) {
            token.id = (byte)22;
        } else if (string.equals("LE")) {
            token.id = (byte)23;
        } else if (string.equals("GT")) {
            token.id = (byte)24;
        } else if (string.equals("GE")) {
            token.id = (byte)25;
        } else if (string.equals("EQ")) {
            token.id = (byte)26;
        } else if (string.equals("NE")) {
            token.id = (byte)27;
        } else if (string.equals("IF")) {
            token.id = (byte)28;
        } else if (string.equals("MIN")) {
            token.id = (byte)29;
        } else if (string.equals("MAX")) {
            token.id = (byte)30;
        } else if (string.equals("LIMIT")) {
            token.id = (byte)31;
        } else if (string.equals("DUP")) {
            token.id = (byte)32;
        } else if (string.equals("EXC")) {
            token.id = (byte)33;
        } else if (string.equals("POP")) {
            token.id = (byte)34;
        } else if (string.equals("UN")) {
            token.id = (byte)35;
        } else if (string.equals("UNKN")) {
            token.id = (byte)36;
        } else if (string.equals("NOW")) {
            token.id = (byte)37;
        } else if (string.equals("TIME")) {
            token.id = (byte)38;
        } else if (string.equals("PI")) {
            token.id = (byte)39;
        } else if (string.equals("E")) {
            token.id = (byte)40;
        } else if (string.equals("AND")) {
            token.id = (byte)41;
        } else if (string.equals("OR")) {
            token.id = (byte)42;
        } else if (string.equals("XOR")) {
            token.id = (byte)43;
        } else if (string.equals("PREV")) {
            token.id = (byte)44;
            token.variable = this.sourceName;
            token.values = this.calculatedValues;
        } else if (string.startsWith("PREV(") && string.endsWith(")")) {
            token.id = (byte)44;
            token.variable = string.substring(5, string.length() - 1);
            token.values = this.dataProcessor.getValues(token.variable);
        } else if (string.equals("INF")) {
            token.id = (byte)45;
        } else if (string.equals("NEGINF")) {
            token.id = (byte)46;
        } else if (string.equals("STEP")) {
            token.id = (byte)47;
        } else if (string.equals("YEAR")) {
            token.id = (byte)48;
        } else if (string.equals("MONTH")) {
            token.id = (byte)49;
        } else if (string.equals("DATE")) {
            token.id = (byte)50;
        } else if (string.equals("HOUR")) {
            token.id = (byte)51;
        } else if (string.equals("MINUTE")) {
            token.id = (byte)52;
        } else if (string.equals("SECOND")) {
            token.id = (byte)53;
        } else if (string.equals("WEEK")) {
            token.id = (byte)54;
        } else if (string.equals("SIGN")) {
            token.id = (byte)55;
        } else if (string.equals("RND")) {
            token.id = (byte)56;
        } else {
            token.id = 0;
            token.variable = string;
            token.values = this.dataProcessor.getValues(token.variable);
        }
        return token;
    }

    double[] calculateValues() {
        for (int i = 0; i < this.timestamps.length; ++i) {
            this.resetStack();
            block60: for (Token token : this.tokens) {
                switch (token.id) {
                    case 1: {
                        this.push(token.number);
                        continue block60;
                    }
                    case 0: {
                        this.push(token.values[i]);
                        continue block60;
                    }
                    case 2: {
                        this.push(this.pop() + this.pop());
                        continue block60;
                    }
                    case 3: {
                        double d3 = this.pop();
                        double d2 = this.pop();
                        this.push(d2 - d3);
                        continue block60;
                    }
                    case 4: {
                        this.push(this.pop() * this.pop());
                        continue block60;
                    }
                    case 5: {
                        double d3 = this.pop();
                        double d2 = this.pop();
                        this.push(d2 / d3);
                        continue block60;
                    }
                    case 6: {
                        double d3 = this.pop();
                        double d2 = this.pop();
                        this.push(d2 % d3);
                        continue block60;
                    }
                    case 7: {
                        this.push(Math.sin(this.pop()));
                        continue block60;
                    }
                    case 8: {
                        this.push(Math.cos(this.pop()));
                        continue block60;
                    }
                    case 9: {
                        this.push(Math.log(this.pop()));
                        continue block60;
                    }
                    case 10: {
                        this.push(Math.exp(this.pop()));
                        continue block60;
                    }
                    case 12: {
                        this.push(Math.atan(this.pop()));
                        continue block60;
                    }
                    case 13: {
                        double d3 = this.pop();
                        double d2 = this.pop();
                        this.push(Math.atan2(d2, d3));
                        continue block60;
                    }
                    case 14: {
                        this.push(Math.floor(this.pop()));
                        continue block60;
                    }
                    case 15: {
                        this.push(Math.ceil(this.pop()));
                        continue block60;
                    }
                    case 16: {
                        this.push(Math.toRadians(this.pop()));
                        continue block60;
                    }
                    case 17: {
                        this.push(Math.toDegrees(this.pop()));
                        continue block60;
                    }
                    case 18: {
                        this.push(Math.round(this.pop()));
                        continue block60;
                    }
                    case 19: {
                        double d3 = this.pop();
                        double d2 = this.pop();
                        this.push(Math.pow(d2, d3));
                        continue block60;
                    }
                    case 20: {
                        this.push(Math.abs(this.pop()));
                        continue block60;
                    }
                    case 11: {
                        this.push(Math.sqrt(this.pop()));
                        continue block60;
                    }
                    case 21: {
                        this.push(Math.random());
                        continue block60;
                    }
                    case 22: {
                        double d3 = this.pop();
                        double d2 = this.pop();
                        this.push(d2 < d3 ? 1.0 : 0.0);
                        continue block60;
                    }
                    case 23: {
                        double d3 = this.pop();
                        double d2 = this.pop();
                        this.push(d2 <= d3 ? 1.0 : 0.0);
                        continue block60;
                    }
                    case 24: {
                        double d3 = this.pop();
                        double d2 = this.pop();
                        this.push(d2 > d3 ? 1.0 : 0.0);
                        continue block60;
                    }
                    case 25: {
                        double d3 = this.pop();
                        double d2 = this.pop();
                        this.push(d2 >= d3 ? 1.0 : 0.0);
                        continue block60;
                    }
                    case 26: {
                        double d3 = this.pop();
                        double d2 = this.pop();
                        this.push(d2 == d3 ? 1.0 : 0.0);
                        continue block60;
                    }
                    case 27: {
                        double d3 = this.pop();
                        double d2 = this.pop();
                        this.push(d2 != d3 ? 1.0 : 0.0);
                        continue block60;
                    }
                    case 28: {
                        double d = this.pop();
                        double d3 = this.pop();
                        double d2 = this.pop();
                        this.push(d2 != 0.0 ? d3 : d);
                        continue block60;
                    }
                    case 29: {
                        this.push(Math.min(this.pop(), this.pop()));
                        continue block60;
                    }
                    case 30: {
                        this.push(Math.max(this.pop(), this.pop()));
                        continue block60;
                    }
                    case 31: {
                        double d = this.pop();
                        double d3 = this.pop();
                        double d2 = this.pop();
                        this.push(d2 < d3 || d2 > d ? Double.NaN : d2);
                        continue block60;
                    }
                    case 32: {
                        this.push(this.peek());
                        continue block60;
                    }
                    case 33: {
                        double d3 = this.pop();
                        double d2 = this.pop();
                        this.push(d3);
                        this.push(d2);
                        continue block60;
                    }
                    case 34: {
                        this.pop();
                        continue block60;
                    }
                    case 35: {
                        this.push(Double.isNaN(this.pop()) ? 1.0 : 0.0);
                        continue block60;
                    }
                    case 36: {
                        this.push(Double.NaN);
                        continue block60;
                    }
                    case 37: {
                        this.push(Util.getTime());
                        continue block60;
                    }
                    case 38: {
                        this.push(Math.round(this.timestamps[i]));
                        continue block60;
                    }
                    case 39: {
                        this.push(Math.PI);
                        continue block60;
                    }
                    case 40: {
                        this.push(Math.E);
                        continue block60;
                    }
                    case 41: {
                        double d3 = this.pop();
                        double d2 = this.pop();
                        this.push(d2 != 0.0 && d3 != 0.0 ? 1.0 : 0.0);
                        continue block60;
                    }
                    case 42: {
                        double d3 = this.pop();
                        double d2 = this.pop();
                        this.push(d2 != 0.0 || d3 != 0.0 ? 1.0 : 0.0);
                        continue block60;
                    }
                    case 43: {
                        double d3 = this.pop();
                        double d2 = this.pop();
                        this.push(d2 != 0.0 && d3 == 0.0 || d2 == 0.0 && d3 != 0.0 ? 1.0 : 0.0);
                        continue block60;
                    }
                    case 44: {
                        this.push(i == 0 ? Double.NaN : token.values[i - 1]);
                        continue block60;
                    }
                    case 45: {
                        this.push(Double.POSITIVE_INFINITY);
                        continue block60;
                    }
                    case 46: {
                        this.push(Double.NEGATIVE_INFINITY);
                        continue block60;
                    }
                    case 47: {
                        this.push(this.timeStep);
                        continue block60;
                    }
                    case 48: {
                        this.push(this.getCalendarField(this.pop(), 1));
                        continue block60;
                    }
                    case 49: {
                        this.push(this.getCalendarField(this.pop(), 2));
                        continue block60;
                    }
                    case 50: {
                        this.push(this.getCalendarField(this.pop(), 5));
                        continue block60;
                    }
                    case 51: {
                        this.push(this.getCalendarField(this.pop(), 11));
                        continue block60;
                    }
                    case 52: {
                        this.push(this.getCalendarField(this.pop(), 12));
                        continue block60;
                    }
                    case 53: {
                        this.push(this.getCalendarField(this.pop(), 13));
                        continue block60;
                    }
                    case 54: {
                        this.push(this.getCalendarField(this.pop(), 3));
                        continue block60;
                    }
                    case 55: {
                        double d2 = this.pop();
                        this.push(Double.isNaN(d2) ? Double.NaN : (d2 > 0.0 ? 1.0 : (d2 < 0.0 ? -1.0 : 0.0)));
                        continue block60;
                    }
                    case 56: {
                        this.push(Math.floor(this.pop() * Math.random()));
                        continue block60;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected RPN token encountered, token.id=" + token.id);
                    }
                }
            }
            this.calculatedValues[i] = this.pop();
            if (i != 0 || this.isStackEmpty()) continue;
            throw new IllegalArgumentException("Stack not empty at the end of calculation. Probably bad RPN expression [" + this.rpnExpression + "]");
        }
        return this.calculatedValues;
    }

    private double getCalendarField(double d, int n) {
        Calendar calendar = Util.getCalendar((long)(d * 1000.0));
        return calendar.get(n);
    }

    private void push(double d) {
        this.stack.push(d);
    }

    private double pop() {
        return this.stack.pop();
    }

    private double peek() {
        return this.stack.peek();
    }

    private void resetStack() {
        this.stack.reset();
    }

    private boolean isStackEmpty() {
        return this.stack.isEmpty();
    }

    private static final class Token {
        byte id = (byte)-1;
        double number = Double.NaN;
        String variable = null;
        double[] values = null;

        private Token() {
        }
    }

    private static final class RpnStack {
        private static final int MAX_STACK_SIZE = 1000;
        private double[] stack = new double[1000];
        private int pos = 0;

        private RpnStack() {
        }

        void push(double d) {
            if (this.pos >= 1000) {
                throw new IllegalArgumentException("PUSH failed, RPN stack full [1000]");
            }
            this.stack[this.pos++] = d;
        }

        double pop() {
            if (this.pos <= 0) {
                throw new IllegalArgumentException("POP failed, RPN stack is empty");
            }
            return this.stack[--this.pos];
        }

        double peek() {
            if (this.pos <= 0) {
                throw new IllegalArgumentException("PEEK failed, RPN stack is empty");
            }
            return this.stack[this.pos - 1];
        }

        void reset() {
            this.pos = 0;
        }

        boolean isEmpty() {
            return this.pos <= 0;
        }
    }
}

