/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.Util;
import org.rrd4j.core.XmlTemplate;
import org.rrd4j.graph.RrdGraphConstants;
import org.rrd4j.graph.RrdGraphDef;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class RrdGraphDefTemplate
extends XmlTemplate
implements RrdGraphConstants {
    static final Color BLIND_COLOR = new Color(0, 0, 0, 0);
    private RrdGraphDef rrdGraphDef;

    public RrdGraphDefTemplate(InputSource inputSource) throws IOException {
        super(inputSource);
    }

    public RrdGraphDefTemplate(File file) throws IOException {
        super(file);
    }

    public RrdGraphDefTemplate(String string) throws IOException {
        super(string);
    }

    public RrdGraphDef getRrdGraphDef() {
        Node[] nodeArray;
        if (!this.root.getTagName().equals("rrd_graph_def")) {
            throw new IllegalArgumentException("XML definition must start with <rrd_graph_def>");
        }
        this.validateTagsOnlyOnce(this.root, new String[]{"filename", "span", "options", "datasources", "graph"});
        this.rrdGraphDef = new RrdGraphDef();
        for (Node node : nodeArray = RrdGraphDefTemplate.getChildNodes(this.root)) {
            String string = node.getNodeName();
            if (string.equals("filename")) {
                this.resolveFilename(node);
                continue;
            }
            if (string.equals("span")) {
                this.resolveSpan(node);
                continue;
            }
            if (string.equals("options")) {
                this.resolveOptions(node);
                continue;
            }
            if (string.equals("datasources")) {
                this.resolveDatasources(node);
                continue;
            }
            if (!string.equals("graph")) continue;
            this.resolveGraphElements(node);
        }
        return this.rrdGraphDef;
    }

    private void resolveGraphElements(Node node) {
        Node[] nodeArray;
        this.validateTagsOnlyOnce(node, new String[]{"area*", "line*", "stack*", "print*", "gprint*", "hrule*", "vrule*", "comment*"});
        for (Node node2 : nodeArray = RrdGraphDefTemplate.getChildNodes(node)) {
            String string = node2.getNodeName();
            if (string.equals("area")) {
                this.resolveArea(node2);
                continue;
            }
            if (string.equals("line")) {
                this.resolveLine(node2);
                continue;
            }
            if (string.equals("stack")) {
                this.resolveStack(node2);
                continue;
            }
            if (string.equals("print")) {
                this.resolvePrint(node2, false);
                continue;
            }
            if (string.equals("gprint")) {
                this.resolvePrint(node2, true);
                continue;
            }
            if (string.equals("hrule")) {
                this.resolveHRule(node2);
                continue;
            }
            if (string.equals("vrule")) {
                this.resolveVRule(node2);
                continue;
            }
            if (!string.equals("comment")) continue;
            this.rrdGraphDef.comment(this.getValue(node2, false));
        }
    }

    private void resolveVRule(Node node) {
        Node[] nodeArray;
        this.validateTagsOnlyOnce(node, new String[]{"time", "color", "legend"});
        long l = Long.MIN_VALUE;
        Paint paint = null;
        String string = null;
        for (Node node2 : nodeArray = RrdGraphDefTemplate.getChildNodes(node)) {
            String string2 = node2.getNodeName();
            if (string2.equals("time")) {
                l = Util.getTimestamp(this.getValue(node2));
                continue;
            }
            if (string2.equals("color")) {
                paint = this.getValueAsColor(node2);
                continue;
            }
            if (!string2.equals("legend")) continue;
            string = this.getValue(node2);
        }
        if (l == Long.MIN_VALUE || paint == null) {
            throw new IllegalArgumentException("Incomplete VRULE settings");
        }
        this.rrdGraphDef.vrule(l, paint, string);
    }

    private void resolveHRule(Node node) {
        Node[] nodeArray;
        this.validateTagsOnlyOnce(node, new String[]{"value", "color", "legend"});
        double d = Double.NaN;
        Paint paint = null;
        String string = null;
        for (Node node2 : nodeArray = RrdGraphDefTemplate.getChildNodes(node)) {
            String string2 = node2.getNodeName();
            if (string2.equals("value")) {
                d = this.getValueAsDouble(node2);
                continue;
            }
            if (string2.equals("color")) {
                paint = this.getValueAsColor(node2);
                continue;
            }
            if (!string2.equals("legend")) continue;
            string = this.getValue(node2);
        }
        if (Double.isNaN(d) || paint == null) {
            throw new IllegalArgumentException("Incomplete HRULE settings");
        }
        this.rrdGraphDef.hrule(d, paint, string);
    }

    private void resolvePrint(Node node, boolean bl) {
        Node[] nodeArray;
        this.validateTagsOnlyOnce(node, new String[]{"datasource", "cf", "format"});
        String string = null;
        String string2 = null;
        ConsolFun consolFun = null;
        for (Node node2 : nodeArray = RrdGraphDefTemplate.getChildNodes(node)) {
            String string3 = node2.getNodeName();
            if (string3.equals("datasource")) {
                string = this.getValue(node2);
                continue;
            }
            if (string3.equals("cf")) {
                consolFun = ConsolFun.valueOf(this.getValue(node2));
                continue;
            }
            if (!string3.equals("format")) continue;
            string2 = this.getValue(node2);
        }
        if (string != null && consolFun != null && string2 != null) {
            if (bl) {
                this.rrdGraphDef.gprint(string, consolFun, string2);
            } else {
                this.rrdGraphDef.print(string, consolFun, string2);
            }
        } else {
            throw new IllegalArgumentException("Incomplete " + (bl ? "GRPINT" : "PRINT") + " settings");
        }
    }

    private void resolveStack(Node node) {
        Node[] nodeArray;
        this.validateTagsOnlyOnce(node, new String[]{"datasource", "color", "legend"});
        String string = null;
        String string2 = null;
        Paint paint = null;
        for (Node node2 : nodeArray = RrdGraphDefTemplate.getChildNodes(node)) {
            String string3 = node2.getNodeName();
            if (string3.equals("datasource")) {
                string = this.getValue(node2);
                continue;
            }
            if (string3.equals("color")) {
                paint = this.getValueAsColor(node2);
                continue;
            }
            if (!string3.equals("legend")) continue;
            string2 = this.getValue(node2);
        }
        if (string != null) {
            if (paint != null) {
                this.rrdGraphDef.stack(string, paint, string2);
            } else {
                this.rrdGraphDef.stack(string, BLIND_COLOR, string2);
            }
        } else {
            throw new IllegalArgumentException("Incomplete STACK settings");
        }
    }

    private void resolveLine(Node node) {
        Node[] nodeArray;
        this.validateTagsOnlyOnce(node, new String[]{"datasource", "color", "legend", "width"});
        String string = null;
        String string2 = null;
        Paint paint = null;
        float f = 1.0f;
        for (Node node2 : nodeArray = RrdGraphDefTemplate.getChildNodes(node)) {
            String string3 = node2.getNodeName();
            if (string3.equals("datasource")) {
                string = this.getValue(node2);
                continue;
            }
            if (string3.equals("color")) {
                paint = this.getValueAsColor(node2);
                continue;
            }
            if (string3.equals("legend")) {
                string2 = this.getValue(node2);
                continue;
            }
            if (!string3.equals("width")) continue;
            f = (float)this.getValueAsDouble(node2);
        }
        if (string != null) {
            if (paint != null) {
                this.rrdGraphDef.line(string, paint, string2, f);
            } else {
                this.rrdGraphDef.line(string, BLIND_COLOR, string2, f);
            }
        } else {
            throw new IllegalArgumentException("Incomplete LINE settings");
        }
    }

    private void resolveArea(Node node) {
        Node[] nodeArray;
        this.validateTagsOnlyOnce(node, new String[]{"datasource", "color", "legend"});
        String string = null;
        String string2 = null;
        Paint paint = null;
        for (Node node2 : nodeArray = RrdGraphDefTemplate.getChildNodes(node)) {
            String string3 = node2.getNodeName();
            if (string3.equals("datasource")) {
                string = this.getValue(node2);
                continue;
            }
            if (string3.equals("color")) {
                paint = this.getValueAsColor(node2);
                continue;
            }
            if (!string3.equals("legend")) continue;
            string2 = this.getValue(node2);
        }
        if (string != null) {
            if (paint != null) {
                this.rrdGraphDef.area(string, paint, string2);
            } else {
                this.rrdGraphDef.area(string, BLIND_COLOR, string2);
            }
        } else {
            throw new IllegalArgumentException("Incomplete AREA settings");
        }
    }

    private void resolveDatasources(Node node) {
        Node[] nodeArray;
        this.validateTagsOnlyOnce(node, new String[]{"def*", "cdef*", "sdef*"});
        for (Node node2 : nodeArray = RrdGraphDefTemplate.getChildNodes(node)) {
            String string = node2.getNodeName();
            if (string.equals("def")) {
                this.resolveDef(node2);
                continue;
            }
            if (string.equals("cdef")) {
                this.resolveCDef(node2);
                continue;
            }
            if (!string.equals("sdef")) continue;
            this.resolveSDef(node2);
        }
    }

    private void resolveSDef(Node node) {
        Node[] nodeArray;
        this.validateTagsOnlyOnce(node, new String[]{"name", "source", "cf"});
        String string = null;
        String string2 = null;
        ConsolFun consolFun = null;
        for (Node node2 : nodeArray = RrdGraphDefTemplate.getChildNodes(node)) {
            String string3 = node2.getNodeName();
            if (string3.equals("name")) {
                string = this.getValue(node2);
                continue;
            }
            if (string3.equals("source")) {
                string2 = this.getValue(node2);
                continue;
            }
            if (!string3.equals("cf")) continue;
            consolFun = ConsolFun.valueOf(this.getValue(node2));
        }
        if (string == null || string2 == null || consolFun == null) {
            throw new IllegalArgumentException("Incomplete SDEF settings");
        }
        this.rrdGraphDef.datasource(string, string2, consolFun);
    }

    private void resolveCDef(Node node) {
        Node[] nodeArray;
        this.validateTagsOnlyOnce(node, new String[]{"name", "rpn"});
        String string = null;
        String string2 = null;
        for (Node node2 : nodeArray = RrdGraphDefTemplate.getChildNodes(node)) {
            String string3 = node2.getNodeName();
            if (string3.equals("name")) {
                string = this.getValue(node2);
                continue;
            }
            if (!string3.equals("rpn")) continue;
            string2 = this.getValue(node2);
        }
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Incomplete CDEF settings");
        }
        this.rrdGraphDef.datasource(string, string2);
    }

    private void resolveDef(Node node) {
        Node[] nodeArray;
        this.validateTagsOnlyOnce(node, new String[]{"name", "rrd", "source", "cf", "backend"});
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        ConsolFun consolFun = null;
        for (Node node2 : nodeArray = RrdGraphDefTemplate.getChildNodes(node)) {
            String string5 = node2.getNodeName();
            if (string5.equals("name")) {
                string = this.getValue(node2);
                continue;
            }
            if (string5.equals("rrd")) {
                string2 = this.getValue(node2);
                continue;
            }
            if (string5.equals("source")) {
                string3 = this.getValue(node2);
                continue;
            }
            if (string5.equals("cf")) {
                consolFun = ConsolFun.valueOf(this.getValue(node2));
                continue;
            }
            if (!string5.equals("backend")) continue;
            string4 = this.getValue(node2);
        }
        if (string == null || string2 == null || string3 == null || consolFun == null) {
            throw new IllegalArgumentException("Incomplete DEF settings");
        }
        this.rrdGraphDef.datasource(string, string2, string3, consolFun, string4);
    }

    private void resolveFilename(Node node) {
        String string = this.getValue(node);
        this.rrdGraphDef.setFilename(string);
    }

    private void resolveSpan(Node node) {
        this.validateTagsOnlyOnce(node, new String[]{"start", "end"});
        String string = this.getChildValue(node, "start");
        String string2 = this.getChildValue(node, "end");
        long[] lArray = Util.getTimestamps(string, string2);
        this.rrdGraphDef.setStartTime(lArray[0]);
        this.rrdGraphDef.setEndTime(lArray[1]);
    }

    private void resolveOptions(Node node) {
        Node[] nodeArray;
        this.validateTagsOnlyOnce(node, new String[]{"anti_aliasing", "use_pool", "time_grid", "value_grid", "alt_y_grid", "alt_y_mrtg", "no_minor_grid", "alt_autoscale", "alt_autoscale_max", "units_exponent", "units_length", "vertical_label", "width", "height", "interlaced", "image_info", "image_format", "image_quality", "background_image", "overlay_image", "unit", "lazy", "min_value", "max_value", "rigid", "base", "logarithmic", "colors", "no_legend", "only_graph", "force_rules_legend", "title", "step", "fonts", "first_day_of_week", "signature"});
        for (Node node2 : nodeArray = RrdGraphDefTemplate.getChildNodes(node)) {
            String string = node2.getNodeName();
            if (string.equals("use_pool")) {
                this.rrdGraphDef.setPoolUsed(this.getValueAsBoolean(node2));
                continue;
            }
            if (string.equals("anti_aliasing")) {
                this.rrdGraphDef.setAntiAliasing(this.getValueAsBoolean(node2));
                continue;
            }
            if (string.equals("time_grid")) {
                this.resolveTimeGrid(node2);
                continue;
            }
            if (string.equals("value_grid")) {
                this.resolveValueGrid(node2);
                continue;
            }
            if (string.equals("no_minor_grid")) {
                this.rrdGraphDef.setNoMinorGrid(this.getValueAsBoolean(node2));
                continue;
            }
            if (string.equals("alt_y_grid")) {
                this.rrdGraphDef.setAltYGrid(this.getValueAsBoolean(node2));
                continue;
            }
            if (string.equals("alt_y_mrtg")) {
                this.rrdGraphDef.setAltYMrtg(this.getValueAsBoolean(node2));
                continue;
            }
            if (string.equals("alt_autoscale")) {
                this.rrdGraphDef.setAltAutoscale(this.getValueAsBoolean(node2));
                continue;
            }
            if (string.equals("alt_autoscale_max")) {
                this.rrdGraphDef.setAltAutoscaleMax(this.getValueAsBoolean(node2));
                continue;
            }
            if (string.equals("units_exponent")) {
                this.rrdGraphDef.setUnitsExponent(this.getValueAsInt(node2));
                continue;
            }
            if (string.equals("units_length")) {
                this.rrdGraphDef.setUnitsLength(this.getValueAsInt(node2));
                continue;
            }
            if (string.equals("vertical_label")) {
                this.rrdGraphDef.setVerticalLabel(this.getValue(node2));
                continue;
            }
            if (string.equals("width")) {
                this.rrdGraphDef.setWidth(this.getValueAsInt(node2));
                continue;
            }
            if (string.equals("height")) {
                this.rrdGraphDef.setHeight(this.getValueAsInt(node2));
                continue;
            }
            if (string.equals("interlaced")) {
                this.rrdGraphDef.setInterlaced(this.getValueAsBoolean(node2));
                continue;
            }
            if (string.equals("image_info")) {
                this.rrdGraphDef.setImageInfo(this.getValue(node2));
                continue;
            }
            if (string.equals("image_format")) {
                this.rrdGraphDef.setImageFormat(this.getValue(node2));
                continue;
            }
            if (string.equals("image_quality")) {
                this.rrdGraphDef.setImageQuality((float)this.getValueAsDouble(node2));
                continue;
            }
            if (string.equals("background_image")) {
                this.rrdGraphDef.setBackgroundImage(this.getValue(node2));
                continue;
            }
            if (string.equals("overlay_image")) {
                this.rrdGraphDef.setOverlayImage(this.getValue(node2));
                continue;
            }
            if (string.equals("unit")) {
                this.rrdGraphDef.setUnit(this.getValue(node2));
                continue;
            }
            if (string.equals("lazy")) {
                this.rrdGraphDef.setLazy(this.getValueAsBoolean(node2));
                continue;
            }
            if (string.equals("min_value")) {
                this.rrdGraphDef.setMinValue(this.getValueAsDouble(node2));
                continue;
            }
            if (string.equals("max_value")) {
                this.rrdGraphDef.setMaxValue(this.getValueAsDouble(node2));
                continue;
            }
            if (string.equals("rigid")) {
                this.rrdGraphDef.setRigid(this.getValueAsBoolean(node2));
                continue;
            }
            if (string.equals("base")) {
                this.rrdGraphDef.setBase(this.getValueAsDouble(node2));
                continue;
            }
            if (string.equals("logarithmic")) {
                this.rrdGraphDef.setLogarithmic(this.getValueAsBoolean(node2));
                continue;
            }
            if (string.equals("colors")) {
                this.resolveColors(node2);
                continue;
            }
            if (string.equals("no_legend")) {
                this.rrdGraphDef.setNoLegend(this.getValueAsBoolean(node2));
                continue;
            }
            if (string.equals("only_graph")) {
                this.rrdGraphDef.setOnlyGraph(this.getValueAsBoolean(node2));
                continue;
            }
            if (string.equals("force_rules_legend")) {
                this.rrdGraphDef.setForceRulesLegend(this.getValueAsBoolean(node2));
                continue;
            }
            if (string.equals("title")) {
                this.rrdGraphDef.setTitle(this.getValue(node2));
                continue;
            }
            if (string.equals("step")) {
                this.rrdGraphDef.setStep(this.getValueAsLong(node2));
                continue;
            }
            if (string.equals("fonts")) {
                this.resolveFonts(node2);
                continue;
            }
            if (string.equals("first_day_of_week")) {
                int n = RrdGraphDefTemplate.resolveFirstDayOfWeek(this.getValue(node2));
                this.rrdGraphDef.setFirstDayOfWeek(n);
                continue;
            }
            if (!string.equals("signature")) continue;
            this.rrdGraphDef.setShowSignature(this.getValueAsBoolean(node2));
        }
    }

    private static int resolveFirstDayOfWeek(String string) {
        if (string.equalsIgnoreCase("sunday")) {
            return 1;
        }
        if (string.equalsIgnoreCase("monday")) {
            return 2;
        }
        if (string.equalsIgnoreCase("tuesday")) {
            return 3;
        }
        if (string.equalsIgnoreCase("wednesday")) {
            return 4;
        }
        if (string.equalsIgnoreCase("thursday")) {
            return 5;
        }
        if (string.equalsIgnoreCase("friday")) {
            return 6;
        }
        if (string.equalsIgnoreCase("saturday")) {
            return 7;
        }
        throw new IllegalArgumentException("Never heard for this day of week: " + string);
    }

    private void resolveFonts(Node node) {
        Node[] nodeArray;
        this.validateTagsOnlyOnce(node, new String[]{"small_font", "large_font"});
        for (Node node2 : nodeArray = RrdGraphDefTemplate.getChildNodes(node)) {
            String string = node2.getNodeName();
            if (string.equals("small_font")) {
                this.rrdGraphDef.setSmallFont(this.resolveFont(node2));
                continue;
            }
            if (!string.equals("large_font")) continue;
            this.rrdGraphDef.setLargeFont(this.resolveFont(node2));
        }
    }

    private Font resolveFont(Node node) {
        Node[] nodeArray;
        this.validateTagsOnlyOnce(node, new String[]{"name", "style", "size"});
        String string = null;
        String string2 = null;
        int n = 0;
        for (Node node2 : nodeArray = RrdGraphDefTemplate.getChildNodes(node)) {
            String string3 = node2.getNodeName();
            if (string3.equals("name")) {
                string = this.getValue(node2);
                continue;
            }
            if (string3.equals("style")) {
                string2 = this.getValue(node2).toLowerCase();
                continue;
            }
            if (!string3.equals("size")) continue;
            n = this.getValueAsInt(node2);
        }
        if (string != null && string2 != null && n > 0) {
            boolean bl = string2.contains("italic");
            int n2 = string2.contains("bold") ? 1 : 0;
            int n3 = 0;
            if (bl && n2 != 0) {
                n3 = 3;
            } else if (bl) {
                n3 = 2;
            } else if (n2 != 0) {
                n3 = 1;
            }
            return new Font(string, n3, n);
        }
        throw new IllegalArgumentException("Incomplete font specification");
    }

    private void resolveColors(Node node) {
        Node[] nodeArray;
        String[] stringArray = new String[COLOR_NAMES.length];
        System.arraycopy(COLOR_NAMES, 0, stringArray, 0, COLOR_NAMES.length);
        this.validateTagsOnlyOnce(node, stringArray);
        for (Node node2 : nodeArray = RrdGraphDefTemplate.getChildNodes(node)) {
            String string = node2.getNodeName();
            this.rrdGraphDef.setColor(string, this.getValueAsColor(node2));
        }
    }

    private void resolveValueGrid(Node node) {
        Node[] nodeArray;
        int n;
        this.validateTagsOnlyOnce(node, new String[]{"show_grid", "grid_step", "label_factor"});
        boolean bl = true;
        double d = Double.NaN;
        int n2 = n = Integer.MIN_VALUE;
        for (Node node2 : nodeArray = RrdGraphDefTemplate.getChildNodes(node)) {
            String string = node2.getNodeName();
            if (string.equals("show_grid")) {
                bl = this.getValueAsBoolean(node2);
                continue;
            }
            if (string.equals("grid_step")) {
                d = this.getValueAsDouble(node2);
                continue;
            }
            if (!string.equals("label_factor")) continue;
            n2 = this.getValueAsInt(node2);
        }
        this.rrdGraphDef.setDrawYGrid(bl);
        if (!Double.isNaN(d) && n2 != n) {
            this.rrdGraphDef.setValueAxis(d, n2);
        } else if (!Double.isNaN(d) || n2 != n) {
            throw new IllegalArgumentException("Incomplete value axis settings");
        }
    }

    private void resolveTimeGrid(Node node) {
        Node[] nodeArray;
        this.validateTagsOnlyOnce(node, new String[]{"show_grid", "minor_grid_unit", "minor_grid_unit_count", "major_grid_unit", "major_grid_unit_count", "label_unit", "label_unit_count", "label_span", "label_format"});
        boolean bl = true;
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MIN_VALUE;
        int n6 = Integer.MIN_VALUE;
        int n7 = Integer.MIN_VALUE;
        String string = null;
        for (Node node2 : nodeArray = RrdGraphDefTemplate.getChildNodes(node)) {
            String string2 = node2.getNodeName();
            if (string2.equals("show_grid")) {
                bl = this.getValueAsBoolean(node2);
                continue;
            }
            if (string2.equals("minor_grid_unit")) {
                n = RrdGraphDefTemplate.resolveTimeUnit(this.getValue(node2));
                continue;
            }
            if (string2.equals("minor_grid_unit_count")) {
                n2 = this.getValueAsInt(node2);
                continue;
            }
            if (string2.equals("major_grid_unit")) {
                n3 = RrdGraphDefTemplate.resolveTimeUnit(this.getValue(node2));
                continue;
            }
            if (string2.equals("major_grid_unit_count")) {
                n4 = this.getValueAsInt(node2);
                continue;
            }
            if (string2.equals("label_unit")) {
                n5 = RrdGraphDefTemplate.resolveTimeUnit(this.getValue(node2));
                continue;
            }
            if (string2.equals("label_unit_count")) {
                n6 = this.getValueAsInt(node2);
                continue;
            }
            if (string2.equals("label_span")) {
                n7 = this.getValueAsInt(node2);
                continue;
            }
            if (!string2.equals("label_format")) continue;
            string = this.getValue(node2);
        }
        this.rrdGraphDef.setDrawXGrid(bl);
        if (n != Integer.MIN_VALUE && n2 != Integer.MIN_VALUE && n3 != Integer.MIN_VALUE && n4 != Integer.MIN_VALUE && n5 != Integer.MIN_VALUE && n6 != Integer.MIN_VALUE && n7 != Integer.MIN_VALUE && string != null) {
            this.rrdGraphDef.setTimeAxis(n, n2, n3, n4, n5, n6, n7, string);
        } else if (n != Integer.MIN_VALUE || n2 != Integer.MIN_VALUE || n3 != Integer.MIN_VALUE || n4 != Integer.MIN_VALUE || n5 != Integer.MIN_VALUE || n6 != Integer.MIN_VALUE || n7 != Integer.MIN_VALUE || string != null) {
            throw new IllegalArgumentException("Incomplete time axis settings");
        }
    }

    private static int resolveTimeUnit(String string) {
        if (string.equalsIgnoreCase("second")) {
            return 13;
        }
        if (string.equalsIgnoreCase("minute")) {
            return 12;
        }
        if (string.equalsIgnoreCase("hour")) {
            return 11;
        }
        if (string.equalsIgnoreCase("day")) {
            return 5;
        }
        if (string.equalsIgnoreCase("week")) {
            return 3;
        }
        if (string.equalsIgnoreCase("month")) {
            return 2;
        }
        if (string.equalsIgnoreCase("year")) {
            return 1;
        }
        throw new IllegalArgumentException("Unknown time unit specified: " + string);
    }
}

