/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import org.rrd4j.core.RrdBackend;

public abstract class RrdByteArrayBackend
extends RrdBackend {
    protected byte[] buffer;

    protected RrdByteArrayBackend(String string) {
        super(string);
    }

    @Override
    protected synchronized void write(long l, byte[] byArray) throws IOException {
        int n = (int)l;
        System.arraycopy(byArray, 0, this.buffer, n, byArray.length);
    }

    @Override
    protected synchronized void read(long l, byte[] byArray) throws IOException {
        int n = (int)l;
        if (n + byArray.length > this.buffer.length) {
            throw new IOException("Not enough bytes available in memory; RRD " + this.getPath());
        }
        System.arraycopy(this.buffer, n, byArray, 0, byArray.length);
    }

    @Override
    public long getLength() {
        return this.buffer.length;
    }

    @Override
    protected void setLength(long l) throws IOException {
        if (l > Integer.MAX_VALUE) {
            throw new IOException("Illegal length: " + l);
        }
        this.buffer = new byte[(int)l];
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    protected boolean isCachingAllowed() {
        return false;
    }
}

