/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdFileBackendFactory;
import org.rrd4j.core.RrdNioBackend;

public class RrdNioBackendFactory
extends RrdFileBackendFactory {
    public static final int DEFAULT_SYNC_PERIOD = 300;
    private static int syncPeriod = 300;
    public static final int DEFAULT_SYNC_CORE_POOL_SIZE = 6;
    private final ScheduledExecutorService syncExecutor = Executors.newScheduledThreadPool(6, new DaemonThreadFactory("RRD4J Sync"));

    public RrdNioBackendFactory() {
        Runtime.getRuntime().addShutdownHook(new Thread("RRD4J Sync-ThreadPool-Shutdown"){

            @Override
            public void run() {
                try {
                    RrdNioBackendFactory.this.syncExecutor.shutdown();
                    RrdNioBackendFactory.this.syncExecutor.awaitTermination(120L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
    }

    public static int getSyncPeriod() {
        return syncPeriod;
    }

    public static void setSyncPeriod(int n) {
        syncPeriod = n;
    }

    @Override
    protected RrdBackend open(String string, boolean bl) throws IOException {
        return new RrdNioBackend(string, bl, this.syncExecutor, syncPeriod);
    }

    @Override
    public String getName() {
        return "NIO";
    }

    static class DaemonThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;
        final String nameSuffix = "]";

        DaemonThreadFactory(String string) {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = string + " Pool [Thread-";
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement() + "]");
            thread.setDaemon(true);
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }
}

