/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.demo;

import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Sample;
import org.rrd4j.core.Util;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;

class MinMax {
    MinMax() {
    }

    public static void main(String[] stringArray) throws IOException {
        long l = Util.getTime();
        long l2 = l + 90000L;
        String string = Util.getRrd4jDemoPath("minmax.rrd");
        String string2 = Util.getRrd4jDemoPath("minmax.png");
        RrdDef rrdDef = new RrdDef(string, l - 1L, 300L);
        rrdDef.addDatasource("a", DsType.GAUGE, 600L, Double.NaN, Double.NaN);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 1, 300);
        rrdDef.addArchive(ConsolFun.MIN, 0.5, 12, 300);
        rrdDef.addArchive(ConsolFun.MAX, 0.5, 12, 300);
        RrdDb rrdDb = new RrdDb(rrdDef);
        for (long i = l; i < l2; i += 300L) {
            Sample sample = rrdDb.createSample(i);
            sample.setValue("a", Math.sin((double)i / 3000.0) * 50.0 + 50.0);
            sample.update();
        }
        RrdGraphDef rrdGraphDef = new RrdGraphDef();
        rrdGraphDef.setFilename(string2);
        rrdGraphDef.setWidth(450);
        rrdGraphDef.setHeight(250);
        rrdGraphDef.setImageFormat("png");
        rrdGraphDef.setTimeSpan(l, l + 86400L);
        rrdGraphDef.setTitle("RRDTool's MINMAX.pl demo");
        rrdGraphDef.datasource("a", string, "a", ConsolFun.AVERAGE);
        rrdGraphDef.datasource("b", string, "a", ConsolFun.MIN);
        rrdGraphDef.datasource("c", string, "a", ConsolFun.MAX);
        rrdGraphDef.area("a", Color.decode("0xb6e4"), "real");
        rrdGraphDef.line("b", (Paint)Color.decode("0x22e9"), "min");
        rrdGraphDef.line("c", (Paint)Color.decode("0xee22"), "max");
        new RrdGraph(rrdGraphDef);
    }
}

