/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.util.ArrayList;
import java.util.List;
import org.rrd4j.graph.CommentText;
import org.rrd4j.graph.ImageWorker;
import org.rrd4j.graph.LegendText;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphConstants;
import org.rrd4j.graph.RrdGraphDef;

class LegendComposer
implements RrdGraphConstants {
    private final RrdGraphDef gdef;
    private final ImageWorker worker;
    private int legX;
    private int legY;
    private final int legWidth;
    private double interLegendSpace;
    private double leading;
    private double smallLeading;
    private double boxSpace;

    LegendComposer(RrdGraph rrdGraph, int n, int n2, int n3) {
        this.gdef = rrdGraph.gdef;
        this.worker = rrdGraph.worker;
        this.legX = n;
        this.legY = n2;
        this.legWidth = n3;
        this.interLegendSpace = rrdGraph.getInterLegendSpace();
        this.leading = rrdGraph.getLeading();
        this.smallLeading = rrdGraph.getSmallLeading();
        this.boxSpace = rrdGraph.getBoxSpace();
    }

    int placeComments() {
        Line line = new Line();
        for (CommentText commentText : this.gdef.comments) {
            if (!commentText.isValidGraphElement()) continue;
            if (!line.canAccommodate(commentText)) {
                line.layoutAndAdvance(false);
                line.clear();
            }
            line.add(commentText);
        }
        line.layoutAndAdvance(true);
        this.worker.dispose();
        return this.legY;
    }

    class Line {
        private String lastMarker;
        private double width;
        private int spaceCount;
        private boolean noJustification;
        private List<CommentText> comments = new ArrayList<CommentText>();

        Line() {
            this.clear();
        }

        void clear() {
            this.lastMarker = "";
            this.width = 0.0;
            this.spaceCount = 0;
            this.noJustification = false;
            this.comments.clear();
        }

        boolean canAccommodate(CommentText commentText) {
            if (this.comments.size() == 0) {
                return true;
            }
            if (this.lastMarker.equals("\\l") || this.lastMarker.equals("\\L") || this.lastMarker.equals("\\c") || this.lastMarker.equals("\\r") || this.lastMarker.equals("\\j") || this.lastMarker.equals("\\s")) {
                return false;
            }
            double d = this.getCommentWidth(commentText);
            if (!this.lastMarker.equals("\\g")) {
                d += LegendComposer.this.interLegendSpace;
            }
            return this.width + d <= (double)LegendComposer.this.legWidth;
        }

        void add(CommentText commentText) {
            double d = this.getCommentWidth(commentText);
            if (this.comments.size() > 0 && !this.lastMarker.equals("\\g")) {
                d += LegendComposer.this.interLegendSpace;
                ++this.spaceCount;
            }
            this.width += d;
            this.lastMarker = commentText.marker;
            this.noJustification |= this.lastMarker.equals("\\J");
            this.comments.add(commentText);
        }

        void layoutAndAdvance(boolean bl) {
            if (this.comments.size() > 0) {
                if (this.lastMarker.equals("\\l") || this.lastMarker.equals("\\L")) {
                    this.placeComments(LegendComposer.this.legX, LegendComposer.this.interLegendSpace);
                } else if (this.lastMarker.equals("\\r")) {
                    this.placeComments((double)(LegendComposer.this.legX + LegendComposer.this.legWidth) - this.width, LegendComposer.this.interLegendSpace);
                } else if (this.lastMarker.equals("\\c")) {
                    this.placeComments((double)LegendComposer.this.legX + ((double)LegendComposer.this.legWidth - this.width) / 2.0, LegendComposer.this.interLegendSpace);
                } else if (this.lastMarker.equals("\\j")) {
                    if (this.spaceCount > 0) {
                        this.placeComments(LegendComposer.this.legX, ((double)LegendComposer.this.legWidth - this.width) / (double)this.spaceCount + LegendComposer.this.interLegendSpace);
                    } else {
                        this.placeComments(LegendComposer.this.legX, LegendComposer.this.interLegendSpace);
                    }
                } else if (this.lastMarker.equals("\\s")) {
                    this.placeComments(LegendComposer.this.legX, LegendComposer.this.interLegendSpace);
                } else if (this.noJustification || bl) {
                    this.placeComments(LegendComposer.this.legX, LegendComposer.this.interLegendSpace);
                } else {
                    this.placeComments(LegendComposer.this.legX, ((double)LegendComposer.this.legWidth - this.width) / (double)this.spaceCount + LegendComposer.this.interLegendSpace);
                }
                if (!this.lastMarker.equals("\\L")) {
                    if (this.lastMarker.equals("\\s")) {
                        LegendComposer.this.legY = (int)((double)LegendComposer.this.legY + LegendComposer.this.smallLeading);
                    } else {
                        LegendComposer.this.legY = (int)((double)LegendComposer.this.legY + LegendComposer.this.leading);
                    }
                }
            }
        }

        private double getCommentWidth(CommentText commentText) {
            double d = LegendComposer.this.worker.getStringWidth(commentText.resolvedText, ((LegendComposer)LegendComposer.this).gdef.smallFont);
            if (commentText instanceof LegendText) {
                d += LegendComposer.this.boxSpace;
            }
            return d;
        }

        private void placeComments(double d, double d2) {
            double d3 = d;
            for (CommentText commentText : this.comments) {
                commentText.x = (int)d3;
                commentText.y = LegendComposer.this.legY;
                d3 += this.getCommentWidth(commentText);
                if (commentText.marker.equals("\\g")) continue;
                d3 += d2;
            }
        }
    }
}

