/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.Font;
import java.awt.Paint;
import org.rrd4j.core.Util;
import org.rrd4j.graph.ImageParameters;
import org.rrd4j.graph.ImageWorker;
import org.rrd4j.graph.Mapper;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphConstants;
import org.rrd4j.graph.RrdGraphDef;

class ValueAxis
implements RrdGraphConstants {
    private static final YLabel[] ylabels = new YLabel[]{new YLabel(0.1, 1, 2, 5, 10), new YLabel(0.2, 1, 5, 10, 20), new YLabel(0.5, 1, 2, 4, 10), new YLabel(1.0, 1, 2, 5, 10), new YLabel(2.0, 1, 5, 10, 20), new YLabel(5.0, 1, 2, 4, 10), new YLabel(10.0, 1, 2, 5, 10), new YLabel(20.0, 1, 5, 10, 20), new YLabel(50.0, 1, 2, 4, 10), new YLabel(100.0, 1, 2, 5, 10), new YLabel(200.0, 1, 5, 10, 20), new YLabel(500.0, 1, 2, 4, 10), new YLabel(1000.0, 1, 2, 5, 10), new YLabel(2000.0, 1, 5, 10, 20), new YLabel(5000.0, 1, 2, 4, 10), new YLabel(10000.0, 1, 2, 5, 10), new YLabel(20000.0, 1, 5, 10, 20), new YLabel(50000.0, 1, 2, 4, 10), new YLabel(100000.0, 1, 2, 5, 10), new YLabel(0.0, 0, 0, 0, 0)};
    private ImageParameters im;
    private ImageWorker worker;
    private RrdGraphDef gdef;
    private Mapper mapper;

    ValueAxis(RrdGraph rrdGraph) {
        this(rrdGraph.im, rrdGraph.worker, rrdGraph.gdef, rrdGraph.mapper);
    }

    ValueAxis(ImageParameters imageParameters, ImageWorker imageWorker, RrdGraphDef rrdGraphDef, Mapper mapper) {
        this.im = imageParameters;
        this.gdef = rrdGraphDef;
        this.worker = imageWorker;
        this.mapper = mapper;
    }

    boolean draw() {
        double d;
        int n;
        int n2;
        Font font = this.gdef.smallFont;
        Paint paint = this.gdef.colors[4];
        Paint paint2 = this.gdef.colors[5];
        Paint paint3 = this.gdef.colors[6];
        int n3 = (int)(this.worker.getFontAscent(font) / 2.0);
        int n4 = 2;
        double d2 = this.im.maxval - this.im.minval;
        double d3 = d2 / this.im.magfact;
        if (Double.isNaN(d3)) {
            return false;
        }
        String string = null;
        if (Double.isNaN(this.im.ygridstep)) {
            if (this.gdef.altYGrid) {
                n2 = (int)Math.ceil(Math.log10(Math.max(Math.abs(this.im.maxval), Math.abs(this.im.minval))));
                if (n2 <= 0) {
                    n2 = 1;
                }
                string = (n = (int)Math.floor(Math.log10(d2))) < 0 ? Util.sprintf("%%%d.%df", n2 - n + 1, -n + 1) : Util.sprintf("%%%d.1f", n2 + 1);
                d = Math.pow(10.0, n);
                if (d == 0.0) {
                    d = 0.1;
                }
                if (d2 / d < 5.0) {
                    d /= 10.0;
                }
                if (d2 / d > 15.0) {
                    d *= 10.0;
                }
                if (d2 / d > 5.0) {
                    n4 = 1;
                    if (d2 / d > 8.0) {
                        n4 = 2;
                    }
                } else {
                    d /= 5.0;
                    n4 = 5;
                }
            } else {
                n2 = 3;
                YLabel yLabel = null;
                while (yLabel == null) {
                    yLabel = this.findYLabel(n2);
                    --n2;
                }
                d = yLabel.grid * this.im.magfact;
                n4 = this.findLabelFactor(yLabel);
            }
        } else {
            d = this.im.ygridstep;
            n4 = this.im.ylabfact;
        }
        n2 = this.im.xorigin;
        n = n2 + this.im.xsize;
        int n5 = (int)(this.im.minval / d - 1.0);
        int n6 = (int)(this.im.maxval / d + 1.0);
        double d4 = d / this.im.magfact;
        for (int i = n5; i <= n6; ++i) {
            int n7 = this.mapper.ytr(d * (double)i);
            if (n7 < this.im.yorigin - this.im.ysize || n7 > this.im.yorigin) continue;
            if (i % n4 == 0) {
                String string2 = i == 0 || this.im.symbol == ' ' ? (d4 < 1.0 ? (i != 0 && this.gdef.altYGrid ? Util.sprintf(string, d4 * (double)i) : Util.sprintf("%4.1f", d4 * (double)i)) : Util.sprintf("%4.0f", d4 * (double)i)) : (d4 < 1.0 ? Util.sprintf("%4.1f %c", d4 * (double)i, Character.valueOf(this.im.symbol)) : Util.sprintf("%4.0f %c", d4 * (double)i, Character.valueOf(this.im.symbol)));
                int n8 = (int)this.worker.getStringWidth(string2, font);
                this.worker.drawString(string2, n2 - n8 - 7, n7 + n3, font, paint3);
                this.worker.drawLine(n2 - 2, n7, n2 + 2, n7, paint2, TICK_STROKE);
                this.worker.drawLine(n - 2, n7, n + 2, n7, paint2, TICK_STROKE);
                this.worker.drawLine(n2, n7, n, n7, paint2, GRID_STROKE);
                continue;
            }
            if (this.gdef.noMinorGrid) continue;
            this.worker.drawLine(n2 - 1, n7, n2 + 1, n7, paint, TICK_STROKE);
            this.worker.drawLine(n - 1, n7, n + 1, n7, paint, TICK_STROKE);
            this.worker.drawLine(n2, n7, n, n7, paint, GRID_STROKE);
        }
        return true;
    }

    private YLabel findYLabel(int n) {
        double d;
        double d2 = this.getScaledRange();
        int n2 = 0;
        while (ValueAxis.ylabels[n2].grid > 0.0) {
            YLabel yLabel = ylabels[n2];
            if (this.getPixelsPerGridline(yLabel) > 5) {
                if (this.im.minval < 0.0 && this.im.maxval > 0.0) {
                    int n3;
                    int n4 = this.findLabelFactor(yLabel);
                    if (n4 == -1) {
                        int n5 = n4 = n == 1 ? 1 : n + 1;
                    }
                    if ((n3 = (int)(d2 / yLabel.grid) / n4 + 1) > n) {
                        return yLabel;
                    }
                } else {
                    return yLabel;
                }
            }
            ++n2;
        }
        for (d = 1.0; d < d2; d *= 10.0) {
        }
        return new YLabel(d / 10.0, 1, 2, 5, 10);
    }

    private int findLabelFactor(YLabel yLabel) {
        int n = this.getPixelsPerGridline(yLabel);
        int n2 = (int)Math.ceil(this.worker.getFontHeight(this.gdef.smallFont));
        for (int i = 0; i < 4; ++i) {
            if (n * yLabel.labelFacts[i] < 2 * n2) continue;
            return yLabel.labelFacts[i];
        }
        return -1;
    }

    private int getPixelsPerGridline(YLabel yLabel) {
        double d = this.getScaledRange();
        return (int)((double)this.im.ysize / (d / yLabel.grid));
    }

    private double getScaledRange() {
        double d = this.im.maxval - this.im.minval;
        return d / this.im.magfact;
    }

    static class YLabel {
        final double grid;
        final int[] labelFacts;

        YLabel(double d, int n, int n2, int n3, int n4) {
            this.grid = d;
            this.labelFacts = new int[]{n, n2, n3, n4};
        }
    }
}

