/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.inspector;

import java.io.File;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.rrd4j.core.Archive;
import org.rrd4j.core.Robin;
import org.rrd4j.core.RrdDb;
import org.rrd4j.inspector.InspectorModel;
import org.rrd4j.inspector.Util;

class DataTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"timestamp", "date", "value"};
    private File file;
    private Object[][] values;
    private int dsIndex = -1;
    private int arcIndex = -1;

    DataTableModel() {
    }

    @Override
    public int getRowCount() {
        if (this.values == null) {
            return 0;
        }
        return this.values.length;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.values == null) {
            return "--";
        }
        return this.values[n][n2];
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object object, int n, int n2) {
        double d;
        assert (n2 == 2) : "Column " + n2 + " is not editable!";
        try {
            d = Double.parseDouble(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            d = Double.NaN;
        }
        if (this.dsIndex >= 0 && this.arcIndex >= 0 && this.file != null) {
            try {
                RrdDb rrdDb = new RrdDb(this.file.getAbsolutePath());
                try {
                    Robin robin = rrdDb.getArchive(this.arcIndex).getRobin(this.dsIndex);
                    robin.setValue(n, d);
                    this.values[n][2] = InspectorModel.formatDouble(robin.getValue(n));
                }
                finally {
                    rrdDb.close();
                }
            }
            catch (Exception exception) {
                Util.error(null, exception);
            }
        }
    }

    void setFile(File file) {
        this.file = file;
        this.setIndex(-1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIndex(int n, int n2) {
        if (this.dsIndex != n || this.arcIndex != n2) {
            this.dsIndex = n;
            this.arcIndex = n2;
            this.values = null;
            if (this.dsIndex >= 0 && this.arcIndex >= 0) {
                try {
                    RrdDb rrdDb = new RrdDb(this.file.getAbsolutePath(), true);
                    try {
                        Archive archive = rrdDb.getArchive(this.arcIndex);
                        Robin robin = archive.getRobin(this.dsIndex);
                        long l = archive.getStartTime();
                        long l2 = archive.getArcStep();
                        double[] dArray = robin.getValues();
                        this.values = new Object[dArray.length][];
                        for (int i = 0; i < dArray.length; ++i) {
                            long l3 = l + (long)i * l2;
                            String string = new Date(l3 * 1000L).toString();
                            String string2 = InspectorModel.formatDouble(dArray[i]);
                            this.values[i] = new Object[]{"" + l3, string, string2};
                        }
                    }
                    finally {
                        rrdDb.close();
                    }
                }
                catch (Exception exception) {
                    Util.error(null, exception);
                }
            }
            this.fireTableDataChanged();
        }
    }
}

