/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.converter;

import java.io.File;
import java.text.DecimalFormat;
import java.util.Date;
import org.rrd4j.core.RrdDb;

public class Converter {
    private static final String FACTORY_NAME = "FILE";
    private static final String SUFFIX = ".jrb";
    private static final DecimalFormat secondsFormatter = new DecimalFormat("##0.000");
    private static final DecimalFormat countFormatter = new DecimalFormat("0000");
    private String[] files;
    private int totalCount;
    private int badCount;
    private int goodCount;

    private Converter(String[] stringArray) {
        try {
            RrdDb.setDefaultFactory(FACTORY_NAME);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        this.files = stringArray;
    }

    private void convertAll() {
        Date date = new Date();
        Converter.println("=======================================================================");
        Converter.println("Converting RRDTool files to Rrd4j native format.");
        Converter.println("Original RRDTool files will not be modified in any way");
        Converter.println("RRD4J files created during the process will have a .jrb suffix");
        Converter.println("=======================================================================");
        for (String string : this.files) {
            this.convertFile(string);
        }
        Converter.println("=======================================================================");
        Converter.println("Finished: " + this.totalCount + " total, " + this.goodCount + " OK, " + this.badCount + " failed");
        Date date2 = new Date();
        double d = (double)(date2.getTime() - date.getTime()) / 1000.0;
        Converter.println("Conversion took " + secondsFormatter.format(d) + " sec");
        if (this.totalCount > 0) {
            double d2 = d / (double)this.totalCount;
            Converter.println("Average per-file conversion time: " + secondsFormatter.format(d2) + " sec");
        }
    }

    private void convertFile(String string) {
        long l = System.currentTimeMillis();
        ++this.totalCount;
        try {
            File file = new File(string);
            Converter.print(countFormatter.format(this.totalCount) + "/" + countFormatter.format(this.files.length) + " " + file.getName() + " ");
            String string2 = file.getCanonicalPath();
            String string3 = string2 + SUFFIX;
            RrdDb rrdDb = new RrdDb(string3, "rrdtool:/" + string2);
            rrdDb.close();
            ++this.goodCount;
            double d = (double)(System.currentTimeMillis() - l) / 1000.0;
            Converter.println("[OK, " + secondsFormatter.format(d) + " sec]");
        }
        catch (Exception exception) {
            ++this.badCount;
            Converter.println("[" + exception + "]");
        }
    }

    private static void println(String string) {
        System.out.println(string);
    }

    private static void print(String string) {
        System.out.print(string);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            Converter.println("Usage  : java -jar converter.jar <RRD file pattern> ...");
            Converter.println("Example: java -jar converter.jar files/*.rrd");
            System.exit(1);
        }
        Converter converter = new Converter(stringArray);
        converter.convertAll();
    }
}

