/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDbPool;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.RrdFileBackendFactory;
import org.rrd4j.core.Util;

class RrdDbPoolNew
extends RrdDbPool {
    private Semaphore capacity;
    private int maxCapacity = 200;
    private final Map<String, RrdEntry> pool = new HashMap<String, RrdEntry>(200);
    private final Semaphore poolLock = new Semaphore(1, true);

    protected RrdDbPoolNew() {
        if (!(RrdBackendFactory.getDefaultFactory() instanceof RrdFileBackendFactory)) {
            throw new RuntimeException("Cannot create instance of " + this.getClass().getName() + " with " + "a default backend factory not derived from RrdFileBackendFactory");
        }
        this.capacity = new Semaphore(this.maxCapacity, true){

            @Override
            public String toString() {
                return "Capacity semaphore: " + super.toString();
            }
        };
    }

    @Override
    public int getOpenFileCount() {
        return this.maxCapacity - this.capacity.availablePermits();
    }

    @Override
    public String[] getOpenFiles() {
        try {
            this.poolLock.acquire();
            HashSet<String> hashSet = new HashSet<String>(this.pool.keySet().size());
            for (Map.Entry<String, RrdEntry> entry : this.pool.entrySet()) {
                RrdEntry rrdEntry = entry.getValue();
                if (rrdEntry == null || rrdEntry.count.get() <= 0) continue;
                hashSet.add(entry.getKey());
            }
            this.poolLock.release();
            return hashSet.toArray(new String[hashSet.size()]);
        }
        catch (InterruptedException interruptedException) {
            return new String[0];
        }
    }

    private RrdEntry getEntry(String string) throws IOException {
        RrdEntry rrdEntry;
        String string2 = Util.getCanonicalPath(string);
        boolean bl = false;
        try {
            this.poolLock.acquire();
            bl = true;
            rrdEntry = this.pool.get(string2);
            if (rrdEntry == null) {
                rrdEntry = new RrdEntry();
                this.pool.put(string2, rrdEntry);
            }
            rrdEntry.rlock.acquire();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        finally {
            if (bl) {
                this.poolLock.release();
            }
        }
        return rrdEntry;
    }

    private RrdEntry getUnusedEntry(String string) throws IOException {
        String string2 = Util.getCanonicalPath(string);
        RrdEntry rrdEntry = this.getEntry(string2);
        rrdEntry.rlock.release();
        do {
            try {
                rrdEntry.ulock.acquire();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("RrdDb acquire interrupted", interruptedException);
            }
            rrdEntry = this.getEntry(string2);
        } while (rrdEntry.count.get() != 0);
        try {
            this.capacity.acquire();
        }
        catch (InterruptedException interruptedException) {
            rrdEntry.rlock.release();
            rrdEntry.ulock.release();
            throw new RuntimeException("RrdDb acquire interrupted", interruptedException);
        }
        return rrdEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(RrdDb rrdDb) throws IOException {
        if (rrdDb == null) {
            return;
        }
        String string = rrdDb.getCanonicalPath();
        RrdEntry rrdEntry = this.getEntry(string);
        try {
            if (rrdEntry.count.get() <= 0) {
                throw new IllegalStateException("Could not release [" + string + "], the file was never requested");
            }
            if (rrdEntry.count.decrementAndGet() <= 0 && rrdEntry.rrdDb != null) {
                rrdEntry.rrdDb.close();
                rrdEntry.rrdDb = null;
                this.capacity.release();
                rrdEntry.count.set(0);
                rrdEntry.ulock.release();
            }
        }
        finally {
            rrdEntry.rlock.release();
        }
        boolean bl = false;
        if (rrdEntry.count.get() == 0) {
            try {
                this.poolLock.acquire();
                bl = true;
                rrdEntry = this.pool.get(string);
                if (rrdEntry != null && rrdEntry.rlock.tryAcquire()) {
                    if (rrdEntry.count.get() == 0) {
                        this.pool.remove(string);
                    }
                    rrdEntry.rlock.release();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                if (bl) {
                    this.poolLock.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RrdDb requestRrdDb(String string) throws IOException {
        RrdEntry rrdEntry;
        block8: {
            rrdEntry = this.getEntry(string);
            try {
                if (rrdEntry.count.get() > 0) {
                    rrdEntry.count.incrementAndGet();
                    break block8;
                }
                try {
                    this.capacity.acquire();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("RrdDb acquire interrupted", interruptedException);
                }
                try {
                    rrdEntry.rrdDb = new RrdDb(string);
                }
                catch (IOException iOException) {
                    this.capacity.release();
                    throw iOException;
                }
                rrdEntry.count.set(1);
                rrdEntry.ulock.tryAcquire();
            }
            finally {
                rrdEntry.rlock.release();
            }
        }
        return rrdEntry.rrdDb;
    }

    @Override
    public RrdDb requestRrdDb(RrdDef rrdDef) throws IOException {
        RrdEntry rrdEntry = null;
        try {
            rrdEntry = this.getUnusedEntry(rrdDef.getPath());
            rrdEntry.rrdDb = new RrdDb(rrdDef);
            rrdEntry.count.set(1);
        }
        catch (IOException iOException) {
            this.capacity.release();
            throw iOException;
        }
        finally {
            rrdEntry.rlock.release();
        }
        return rrdEntry.rrdDb;
    }

    @Override
    public RrdDb requestRrdDb(String string, String string2) throws IOException {
        RrdEntry rrdEntry = null;
        try {
            rrdEntry = this.getUnusedEntry(string);
            rrdEntry.rrdDb = new RrdDb(string, string2);
            rrdEntry.count.set(1);
        }
        catch (IOException iOException) {
            this.capacity.release();
            throw iOException;
        }
        finally {
            rrdEntry.rlock.release();
        }
        return rrdEntry.rrdDb;
    }

    @Override
    public void setCapacity(int n) {
        int n2 = this.capacity.drainPermits();
        if (n2 != this.maxCapacity) {
            this.capacity.release(n2);
            throw new RuntimeException("Can only be done on a empty pool");
        }
        this.capacity = new Semaphore(n, true){

            @Override
            public String toString() {
                return "Capacity semaphore: " + super.toString();
            }
        };
        this.maxCapacity = n;
    }

    @Override
    public int getCapacity() {
        return this.maxCapacity;
    }

    @Override
    public int getOpenCount(RrdDb rrdDb) throws IOException {
        String string = rrdDb.getCanonicalPath();
        RrdEntry rrdEntry = this.pool.get(string);
        if (rrdEntry == null) {
            return 0;
        }
        return rrdEntry.count.get();
    }

    @Override
    public int getOpenCount(String string) throws IOException {
        String string2 = Util.getCanonicalPath(string);
        RrdEntry rrdEntry = this.pool.get(string2);
        if (rrdEntry == null) {
            return 0;
        }
        return rrdEntry.count.get();
    }

    private static class RrdEntry {
        volatile RrdDb rrdDb = null;
        final AtomicInteger count = new AtomicInteger(0);
        final Semaphore ulock = new Semaphore(1, true);
        final Semaphore rlock = new Semaphore(1, true);

        private RrdEntry() {
        }
    }
}

