/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import org.rrd4j.core.RrdPrimitive;
import org.rrd4j.core.RrdUpdater;

class RrdDoubleMatrix
extends RrdPrimitive {
    private final int rows;
    private final int columns;

    RrdDoubleMatrix(RrdUpdater rrdUpdater, int n, int n2, boolean bl) throws IOException {
        super(rrdUpdater, 2, n * n2, false);
        this.rows = n;
        this.columns = n2;
        if (bl) {
            this.writeDouble(0, Double.NaN, this.rows * this.columns);
        }
    }

    void set(int n, int n2, double d) throws IOException {
        this.writeDouble(this.columns * n2 + n, d);
    }

    void set(int n, int n2, double d, int n3) throws IOException {
        assert (n2 + n3 <= this.rows) : "Invalid robin index supplied: index=" + n2 + ", count=" + n3 + ", length=" + this.rows;
        int n4 = this.columns * n2 + n;
        for (int i = 0; i < n3; ++i) {
            this.writeDouble(n4, d);
            n4 += this.columns;
        }
    }

    public void set(int n, int n2, double[] dArray) throws IOException {
        int n3 = dArray.length;
        assert (n2 + n3 <= this.rows) : "Invalid robin index supplied: index=" + n2 + ", count=" + n3 + ", length=" + this.rows;
        int n4 = this.columns * n2 + n;
        for (int i = 0; i < n3; ++i) {
            this.writeDouble(n4, dArray[i]);
            n4 += this.columns;
        }
    }

    double get(int n, int n2) throws IOException {
        assert (n2 < this.rows) : "Invalid index supplied: " + n2 + ", length=" + this.rows;
        return this.readDouble(this.columns * n2 + n);
    }

    double[] get(int n, int n2, int n3) throws IOException {
        assert (n2 + n3 <= this.rows) : "Invalid index/count supplied: " + n2 + "/" + n3 + " (length=" + this.rows + ")";
        double[] dArray = new double[n3];
        int n4 = this.columns * n2 + n;
        for (int i = 0; i < n3; ++i) {
            dArray[i] = this.readDouble(n4);
            n4 += this.columns;
        }
        return dArray;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }
}

