/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.ArcDef;
import org.rrd4j.core.Archive;
import org.rrd4j.core.Datasource;
import org.rrd4j.core.DsDef;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Util;

public class RrdToolkit {
    public static void addDatasource(String string, String string2, DsDef dsDef) throws IOException {
        RrdToolkit.addDatasources(string, string2, Collections.singleton(dsDef));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDatasources(String string, String string2, Iterable<DsDef> iterable) throws IOException {
        if (Util.sameFilePath(string, string2)) {
            throw new IllegalArgumentException("Source and destination paths are the same");
        }
        RrdDb rrdDb = new RrdDb(string);
        try {
            RrdDef rrdDef = rrdDb.getRrdDef();
            rrdDef.setPath(string2);
            for (DsDef dsDef : iterable) {
                rrdDef.addDatasource(dsDef);
            }
            RrdDb rrdDb2 = new RrdDb(rrdDef);
            try {
                rrdDb.copyStateTo(rrdDb2);
            }
            finally {
                rrdDb2.close();
            }
        }
        finally {
            rrdDb.close();
        }
    }

    public static void addDatasource(String string, DsDef dsDef, boolean bl) throws IOException {
        RrdToolkit.addDatasources(string, Collections.singleton(dsDef), bl);
    }

    public static void addDatasources(String string, Iterable<DsDef> iterable, boolean bl) throws IOException {
        String string2 = Util.getTmpFilename();
        RrdToolkit.addDatasources(string, string2, iterable);
        RrdToolkit.copyFile(string2, string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDatasource(String string, String string2, String string3) throws IOException {
        if (Util.sameFilePath(string, string2)) {
            throw new IllegalArgumentException("Source and destination paths are the same");
        }
        RrdDb rrdDb = new RrdDb(string);
        try {
            RrdDef rrdDef = rrdDb.getRrdDef();
            rrdDef.setPath(string2);
            rrdDef.removeDatasource(string3);
            RrdDb rrdDb2 = new RrdDb(rrdDef);
            try {
                rrdDb.copyStateTo(rrdDb2);
            }
            finally {
                rrdDb2.close();
            }
        }
        finally {
            rrdDb.close();
        }
    }

    public static void removeDatasource(String string, String string2, boolean bl) throws IOException {
        String string3 = Util.getTmpFilename();
        RrdToolkit.removeDatasource(string, string3, string2);
        RrdToolkit.copyFile(string3, string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameDatasource(String string, String string2, String string3) throws IOException {
        block4: {
            RrdDb rrdDb = new RrdDb(string);
            try {
                if (rrdDb.containsDs(string2)) {
                    Datasource datasource = rrdDb.getDatasource(string2);
                    datasource.setDsName(string3);
                    break block4;
                }
                throw new IllegalArgumentException("Could not find datasource [" + string2 + "] in file " + string);
            }
            finally {
                rrdDb.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int forceZerosForNans(String string, String string2) throws IOException {
        RrdDb rrdDb = new RrdDb(string);
        try {
            Datasource[] datasourceArray;
            if (string2 == null) {
                datasourceArray = rrdDb.getDatasources();
            } else if (rrdDb.containsDs(string2)) {
                datasourceArray = new Datasource[]{rrdDb.getDatasource(string2)};
            } else {
                throw new IllegalArgumentException("Could not find datasource [" + string2 + "] in file " + string);
            }
            int n = 0;
            for (Datasource datasource : datasourceArray) {
                String string3 = datasource.getName();
                if (string3.endsWith("!")) continue;
                datasource.setDsName(string3 + "!");
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            rrdDb.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addArchive(String string, String string2, ArcDef arcDef) throws IOException {
        if (Util.sameFilePath(string, string2)) {
            throw new IllegalArgumentException("Source and destination paths are the same");
        }
        RrdDb rrdDb = new RrdDb(string);
        try {
            RrdDef rrdDef = rrdDb.getRrdDef();
            rrdDef.setPath(string2);
            rrdDef.addArchive(arcDef);
            RrdDb rrdDb2 = new RrdDb(rrdDef);
            try {
                rrdDb.copyStateTo(rrdDb2);
            }
            finally {
                rrdDb2.close();
            }
        }
        finally {
            rrdDb.close();
        }
    }

    public static void addArchive(String string, ArcDef arcDef, boolean bl) throws IOException {
        String string2 = Util.getTmpFilename();
        RrdToolkit.addArchive(string, string2, arcDef);
        RrdToolkit.copyFile(string2, string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeArchive(String string, String string2, ConsolFun consolFun, int n) throws IOException {
        if (Util.sameFilePath(string, string2)) {
            throw new IllegalArgumentException("Source and destination paths are the same");
        }
        RrdDb rrdDb = new RrdDb(string);
        try {
            RrdDef rrdDef = rrdDb.getRrdDef();
            rrdDef.setPath(string2);
            rrdDef.removeArchive(consolFun, n);
            RrdDb rrdDb2 = new RrdDb(rrdDef);
            try {
                rrdDb.copyStateTo(rrdDb2);
            }
            finally {
                rrdDb2.close();
            }
        }
        finally {
            rrdDb.close();
        }
    }

    public static void removeArchive(String string, ConsolFun consolFun, int n, boolean bl) throws IOException {
        String string2 = Util.getTmpFilename();
        RrdToolkit.removeArchive(string, string2, consolFun, n);
        RrdToolkit.copyFile(string2, string, bl);
    }

    private static void copyFile(String string, String string2, boolean bl) throws IOException {
        File file = new File(string);
        File file2 = new File(string2);
        if (bl) {
            String string3 = RrdToolkit.getBackupPath(string2);
            File file3 = new File(string3);
            RrdToolkit.deleteFile(file3);
            if (!file2.renameTo(file3)) {
                throw new IOException("Could not create backup file " + string3);
            }
        }
        RrdToolkit.deleteFile(file2);
        if (!file.renameTo(file2)) {
            throw new IOException("Could not create file " + string2 + " from " + string);
        }
    }

    private static String getBackupPath(String string) {
        String string2 = string;
        while (Util.fileExists(string2 = string2 + ".bak")) {
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDsHeartbeat(String string, String string2, long l) throws IOException {
        RrdDb rrdDb = new RrdDb(string);
        try {
            Datasource datasource = rrdDb.getDatasource(string2);
            datasource.setHeartbeat(l);
        }
        finally {
            rrdDb.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDsHeartbeat(String string, int n, long l) throws IOException {
        RrdDb rrdDb = new RrdDb(string);
        try {
            Datasource datasource = rrdDb.getDatasource(n);
            datasource.setHeartbeat(l);
        }
        finally {
            rrdDb.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDsMinValue(String string, String string2, double d, boolean bl) throws IOException {
        RrdDb rrdDb = new RrdDb(string);
        try {
            Datasource datasource = rrdDb.getDatasource(string2);
            datasource.setMinValue(d, bl);
        }
        finally {
            rrdDb.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDsMaxValue(String string, String string2, double d, boolean bl) throws IOException {
        RrdDb rrdDb = new RrdDb(string);
        try {
            Datasource datasource = rrdDb.getDatasource(string2);
            datasource.setMaxValue(d, bl);
        }
        finally {
            rrdDb.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDsMinMaxValue(String string, String string2, double d, double d2, boolean bl) throws IOException {
        RrdDb rrdDb = new RrdDb(string);
        try {
            Datasource datasource = rrdDb.getDatasource(string2);
            datasource.setMinMaxValue(d, d2, bl);
        }
        finally {
            rrdDb.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setArcXff(String string, ConsolFun consolFun, int n, double d) throws IOException {
        RrdDb rrdDb = new RrdDb(string);
        try {
            Archive archive = rrdDb.getArchive(consolFun, n);
            archive.setXff(d);
        }
        finally {
            rrdDb.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resizeArchive(String string, String string2, ConsolFun consolFun, int n, int n2) throws IOException {
        block8: {
            if (Util.sameFilePath(string, string2)) {
                throw new IllegalArgumentException("Source and destination paths are the same");
            }
            if (n2 < 2) {
                throw new IllegalArgumentException("New archive size must be at least 2");
            }
            RrdDb rrdDb = new RrdDb(string);
            try {
                RrdDef rrdDef = rrdDb.getRrdDef();
                ArcDef arcDef = rrdDef.findArchive(consolFun, n);
                if (arcDef.getRows() == n2) break block8;
                arcDef.setRows(n2);
                rrdDef.setPath(string2);
                RrdDb rrdDb2 = new RrdDb(rrdDef);
                try {
                    rrdDb.copyStateTo(rrdDb2);
                }
                finally {
                    rrdDb2.close();
                }
            }
            finally {
                rrdDb.close();
            }
        }
    }

    public static void resizeArchive(String string, ConsolFun consolFun, int n, int n2, boolean bl) throws IOException {
        String string2 = Util.getTmpFilename();
        RrdToolkit.resizeArchive(string, string2, consolFun, n, n2);
        RrdToolkit.copyFile(string2, string, bl);
    }

    private static void deleteFile(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not delete file: " + file.getCanonicalPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void split(String string) throws IOException {
        RrdDb rrdDb = new RrdDb(string);
        try {
            String[] stringArray;
            for (String string2 : stringArray = rrdDb.getDsNames()) {
                RrdDef rrdDef = rrdDb.getRrdDef();
                rrdDef.setPath(RrdToolkit.createSplitPath(string2, string));
                rrdDef.saveSingleDatasource(string2);
                RrdDb rrdDb2 = new RrdDb(rrdDef);
                try {
                    rrdDb.copyStateTo(rrdDb2);
                }
                finally {
                    rrdDb2.close();
                }
            }
        }
        finally {
            rrdDb.close();
        }
    }

    public static String[] getCanonicalPaths(String string, String string2, boolean bl) throws IOException {
        File file = new File(string);
        if (!file.isDirectory()) {
            throw new IOException("Not a directory: " + string);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        RrdToolkit.traverseDirectory(new File(string), string2, bl, linkedList);
        Object[] objectArray = linkedList.toArray(new String[linkedList.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    private static void traverseDirectory(File file, String string, boolean bl, List<String> list) throws IOException {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory() && bl) {
                RrdToolkit.traverseDirectory(file2, string, bl, list);
                continue;
            }
            if (!file2.isFile() || !file2.getName().endsWith(string)) continue;
            list.add(file2.getCanonicalPath());
        }
    }

    private static String createSplitPath(String string, String string2) {
        File file = new File(string2);
        String string3 = string + "-" + file.getName();
        String string4 = file.getAbsolutePath();
        String string5 = string4.substring(0, 1 + string4.lastIndexOf(Util.getFileSeparator()));
        return string5 + string3;
    }
}

