/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.rrd4j.core.jrrd.Constants;
import org.rrd4j.core.jrrd.UnivalArray;

class RRDFile
implements Constants {
    private int alignment;
    private int longSize = 4;
    final RandomAccessFile ras;
    private ByteBuffer bbuffer = ByteBuffer.allocate(1024);
    private byte[] buffer = this.bbuffer.array();
    private ByteOrder order;

    RRDFile(String string) throws IOException {
        this(new File(string));
    }

    RRDFile(File file) throws IOException {
        this.ras = new RandomAccessFile(file, "r");
        this.initDataLayout(file);
    }

    private int read(int n) throws IOException {
        this.bbuffer.clear();
        int n2 = this.ras.read(this.buffer, 0, n);
        return n2;
    }

    private void initDataLayout(File file) throws IOException {
        if (file.exists()) {
            this.read(32);
            int n = this.indexOf(FLOAT_COOKIE_BIG_ENDIAN, this.buffer);
            if (n != -1) {
                this.order = ByteOrder.BIG_ENDIAN;
            } else {
                n = this.indexOf(FLOAT_COOKIE_LITTLE_ENDIAN, this.buffer);
                if (n != -1) {
                    this.order = ByteOrder.LITTLE_ENDIAN;
                } else {
                    throw new IOException("Invalid RRD file");
                }
            }
            this.bbuffer.order(this.order);
            switch (n) {
                case 12: {
                    this.alignment = 4;
                    break;
                }
                case 16: {
                    this.alignment = 8;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported architecture");
                }
            }
            this.bbuffer.position(n + 8);
            int n2 = this.bbuffer.getInt();
            int n3 = this.bbuffer.getInt();
            if (n2 == 0 || n3 == 0) {
                this.longSize = 8;
            }
        }
        this.ras.seek(0L);
    }

    private int indexOf(byte[] byArray, byte[] byArray2) {
        return new String(byArray2).indexOf(new String(byArray));
    }

    boolean isBigEndian() {
        return this.order == ByteOrder.BIG_ENDIAN;
    }

    int getAlignment() {
        return this.alignment;
    }

    double readDouble() throws IOException {
        this.read(8);
        return this.bbuffer.getDouble();
    }

    int readInt() throws IOException {
        this.read(4);
        return this.bbuffer.getInt();
    }

    int readLong() throws IOException {
        this.read(this.longSize);
        if (this.longSize == 4) {
            return this.bbuffer.getInt();
        }
        return (int)this.bbuffer.getLong();
    }

    String readString(int n) throws IOException {
        this.ras.read(this.buffer, 0, n);
        return new String(this.buffer, 0, n).trim();
    }

    void skipBytes(int n) throws IOException {
        this.ras.skipBytes(n);
    }

    int align(int n) throws IOException {
        int n2 = (int)((long)n - this.ras.getFilePointer() % (long)n) % n;
        if (n2 != 0) {
            this.ras.skipBytes(n2);
        }
        return n2;
    }

    int align() throws IOException {
        return this.align(this.alignment);
    }

    long info() throws IOException {
        return this.ras.getFilePointer();
    }

    long getFilePointer() throws IOException {
        return this.ras.getFilePointer();
    }

    void close() throws IOException {
        this.ras.close();
    }

    void read(ByteBuffer byteBuffer) throws IOException {
        this.ras.getChannel().read(byteBuffer);
    }

    UnivalArray getUnivalArray(int n) throws IOException {
        return new UnivalArray(this, n);
    }

    int getBits() {
        return this.longSize * 8;
    }
}

