/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.rrd4j.core.jrrd.Archive;
import org.rrd4j.core.jrrd.ConsolidationFunctionType;
import org.rrd4j.core.jrrd.DataChunk;
import org.rrd4j.core.jrrd.DataSource;
import org.rrd4j.core.jrrd.Header;
import org.rrd4j.core.jrrd.RRDFile;

public class RRDatabase {
    RRDFile rrdFile;
    private String name;
    Header header;
    private ArrayList<DataSource> dataSources;
    private ArrayList<Archive> archives;
    Date lastUpdate;
    private Map<String, Integer> nameindex;

    public RRDatabase(String string) throws IOException {
        this(new File(string));
    }

    public RRDatabase(File file) throws IOException {
        Object object;
        int n;
        Object object2;
        int n2;
        this.name = file.getName();
        this.rrdFile = new RRDFile(file);
        this.header = new Header(this.rrdFile);
        this.nameindex = new HashMap<String, Integer>(this.header.dsCount);
        this.dataSources = new ArrayList(this.header.dsCount);
        for (n2 = 0; n2 < this.header.dsCount; ++n2) {
            object2 = new DataSource(this.rrdFile);
            this.nameindex.put(((DataSource)object2).getName(), n2);
            this.dataSources.add((DataSource)object2);
        }
        this.archives = new ArrayList(this.header.dsCount);
        for (n2 = 0; n2 < this.header.rraCount; ++n2) {
            object2 = new Archive(this);
            this.archives.add((Archive)object2);
        }
        this.rrdFile.align();
        long l = (long)this.rrdFile.readLong() * 1000L;
        if (this.header.getVersionAsInt() >= 3) {
            long l2 = this.rrdFile.readLong();
            l += l2 / 1000L;
            this.rrdFile.align();
        }
        this.lastUpdate = new Date(l);
        for (n = 0; n < this.header.dsCount; ++n) {
            object = this.dataSources.get(n);
            ((DataSource)object).loadPDPStatusBlock(this.rrdFile);
        }
        this.rrdFile.align(8);
        if (this.header.getVersionAsInt() == 1 && this.rrdFile.getBits() == 32) {
            this.rrdFile.ras.readInt();
        }
        for (n = 0; n < this.header.rraCount; ++n) {
            object = this.archives.get(n);
            ((Archive)object).loadCDPStatusBlocks(this.rrdFile, this.header.dsCount);
        }
        for (n = 0; n < this.header.rraCount; ++n) {
            object = this.archives.get(n);
            ((Archive)object).loadCurrentRow(this.rrdFile);
        }
        for (n = 0; n < this.header.rraCount; ++n) {
            object = this.archives.get(n);
            ((Archive)object).loadData(this.rrdFile, this.header.dsCount);
        }
    }

    public Header getHeader() {
        return this.header;
    }

    public Set<String> getDataSourcesName() {
        return this.nameindex.keySet();
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public DataSource getDataSource(int n) {
        return this.dataSources.get(n);
    }

    public Iterator<DataSource> getDataSources() {
        return this.dataSources.iterator();
    }

    public Archive getArchive(int n) {
        return this.archives.get(n);
    }

    public Archive getArchive(String string) {
        return this.archives.get(this.nameindex.get(string));
    }

    public Iterator<Archive> getArchives() {
        return this.archives.iterator();
    }

    public int getNumArchives() {
        return this.header.rraCount;
    }

    public Iterator<Archive> getArchives(ConsolidationFunctionType consolidationFunctionType) {
        return this.getArchiveList(consolidationFunctionType).iterator();
    }

    ArrayList<Archive> getArchiveList(ConsolidationFunctionType consolidationFunctionType) {
        ArrayList<Archive> arrayList = new ArrayList<Archive>();
        for (Archive archive : this.archives) {
            if (!archive.getType().equals((Object)consolidationFunctionType)) continue;
            arrayList.add(archive);
        }
        return arrayList;
    }

    public void close() throws IOException {
        this.rrdFile.close();
    }

    public void printInfo(PrintStream printStream) {
        DecimalFormat decimalFormat = new DecimalFormat("0.0000000000E0");
        this.printInfo(printStream, decimalFormat);
    }

    public DataChunk getData(ConsolidationFunctionType consolidationFunctionType) throws IOException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, 0);
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(5, -1);
        return this.getData(consolidationFunctionType, calendar2.getTime(), calendar.getTime(), 1L);
    }

    public DataChunk getData(ConsolidationFunctionType consolidationFunctionType, Date date, Date date2, long l) throws IOException {
        long l2 = date.getTime() / 1000L;
        long l3 = date2.getTime() / 1000L;
        return this.getData(consolidationFunctionType, l3, l2, l);
    }

    public DataChunk getData(ConsolidationFunctionType consolidationFunctionType, long l, long l2, long l3) throws IOException {
        ArrayList<Archive> arrayList = this.getArchiveList(consolidationFunctionType);
        if (arrayList.size() == 0) {
            throw new IllegalArgumentException("Database does not contain an Archive of consolidation function type " + (Object)((Object)consolidationFunctionType));
        }
        Archive archive = this.findBestArchive(l, l2, l3, arrayList);
        l3 = this.header.pdpStep * archive.pdpCount;
        l -= l % l3;
        if (l2 % l3 != 0L) {
            l2 += l3 - l2 % l3;
        }
        int n = (int)((l2 - l) / l3 + 1L);
        long l4 = this.lastUpdate.getTime() / 1000L;
        long l5 = l4 - l4 % l3;
        long l6 = l5 - l3 * (long)(archive.rowCount - 1);
        int n2 = (int)((l - l6) / l3);
        int n3 = (int)((l5 - l2) / l3);
        DataChunk dataChunk = new DataChunk(this.nameindex, l, n2, n3, l3, this.header.dsCount, n);
        archive.loadData(dataChunk);
        return dataChunk;
    }

    private Archive findBestArchive(long l, long l2, long l3, ArrayList<Archive> arrayList) {
        Archive archive = null;
        Archive archive2 = null;
        Archive archive3 = null;
        long l4 = this.lastUpdate.getTime() / 1000L;
        boolean bl = true;
        boolean bl2 = true;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        Iterator<Archive> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Archive archive4;
            archive = archive4 = iterator.next();
            long l8 = l4 - l4 % (long)(archive.pdpCount * this.header.pdpStep);
            long l9 = l8 - (long)(archive.pdpCount * archive.rowCount * this.header.pdpStep);
            long l10 = l2 - l;
            if (l8 >= l2 && l9 < l) {
                l7 = Math.abs(l3 - (long)(this.header.pdpStep * archive.pdpCount));
                if (!bl2 && l7 >= l6) continue;
                bl2 = false;
                l6 = l7;
                archive2 = archive;
                continue;
            }
            long l11 = l10;
            if (l9 > l) {
                l11 -= l9 - l;
            }
            if (l8 < l2) {
                l11 -= l2 - l8;
            }
            if (!bl && l5 >= l11) continue;
            bl = false;
            l5 = l11;
            archive3 = archive;
        }
        if (!bl2) {
            archive = archive2;
        } else if (!bl) {
            archive = archive3;
        }
        return archive;
    }

    public void printInfo(PrintStream printStream, NumberFormat numberFormat) {
        printStream.print("filename = \"");
        printStream.print(this.name);
        printStream.println("\"");
        printStream.print("rrd_version = \"");
        printStream.print(this.header.version);
        printStream.println("\"");
        printStream.print("step = ");
        printStream.println(this.header.pdpStep);
        printStream.print("last_update = ");
        printStream.println(this.lastUpdate.getTime() / 1000L);
        for (DataSource object : this.dataSources) {
            object.printInfo(printStream, numberFormat);
        }
        int n = 0;
        for (Archive archive : this.archives) {
            archive.printInfo(printStream, numberFormat, n++);
        }
    }

    public void toXml(PrintStream printStream) {
        Object object;
        int n;
        printStream.println("<!--");
        printStream.println("  -- Round Robin RRDatabase Dump ");
        printStream.println("  -- Generated by jRRD <ciaran@codeloop.com>");
        printStream.println("  -->");
        printStream.println("<rrd>");
        printStream.print("\t<version> ");
        printStream.print(this.header.version);
        printStream.println(" </version>");
        printStream.print("\t<step> ");
        printStream.print(this.header.pdpStep);
        printStream.println(" </step> <!-- Seconds -->");
        printStream.print("\t<lastupdate> ");
        printStream.print(this.lastUpdate.getTime() / 1000L);
        printStream.print(" </lastupdate> <!-- ");
        printStream.print(this.lastUpdate.toString());
        printStream.println(" -->");
        printStream.println();
        for (n = 0; n < this.header.dsCount; ++n) {
            object = this.dataSources.get(n);
            ((DataSource)object).toXml(printStream);
        }
        printStream.println("<!-- Round Robin Archives -->");
        for (n = 0; n < this.header.rraCount; ++n) {
            object = this.archives.get(n);
            ((Archive)object).toXml(printStream);
        }
        printStream.println("</rrd>");
    }

    public String toString() {
        String string = this.rrdFile.isBigEndian() ? "Big" : "Little";
        StringBuilder stringBuilder = new StringBuilder(string + " endian" + ", " + this.rrdFile.getBits() + " bits\n");
        stringBuilder.append(this.header.toString());
        stringBuilder.append(", lastupdate: ");
        stringBuilder.append(this.lastUpdate.getTime() / 1000L);
        for (DataSource object : this.dataSources) {
            stringBuilder.append("\n\t");
            stringBuilder.append(object.toString());
        }
        for (Archive archive : this.archives) {
            stringBuilder.append("\n\t");
            stringBuilder.append(archive.toString());
        }
        return stringBuilder.toString();
    }
}

