/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.rrd4j.core.jrrd.RRDFile;

class UnivalArray {
    private final ByteBuffer buffer;
    private final int sizeoflong;

    public UnivalArray(RRDFile rRDFile, int n) throws IOException {
        this.sizeoflong = rRDFile.getBits();
        this.buffer = ByteBuffer.allocate(n * 8);
        if (rRDFile.isBigEndian()) {
            this.buffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        rRDFile.read(this.buffer);
    }

    public long getLong(Enum<?> enum_) {
        this.buffer.position(8 * enum_.ordinal());
        if (this.sizeoflong == 64) {
            return this.buffer.getLong();
        }
        return this.buffer.getInt();
    }

    public double getDouble(Enum<?> enum_) {
        this.buffer.position(8 * enum_.ordinal());
        return this.buffer.getDouble();
    }
}

