/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.timespec;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import org.rrd4j.core.Util;
import org.rrd4j.core.timespec.TimeParser;

public class Epoch
extends JFrame {
    private static final String[] supportedFormats = new String[]{"MM/dd/yy HH:mm:ss", "dd.MM.yy HH:mm:ss", "yy-MM-dd HH:mm:ss", "MM/dd/yy HH:mm", "dd.MM.yy HH:mm", "yy-MM-dd HH:mm", "MM/dd/yy", "dd.MM.yy", "yy-MM-dd", "HH:mm MM/dd/yy", "HH:mm dd.MM.yy", "HH:mm yy-MM-dd", "HH:mm:ss MM/dd/yy", "HH:mm:ss dd.MM.yy", "HH:mm:ss yy-MM-dd"};
    private static final SimpleDateFormat[] parsers = new SimpleDateFormat[supportedFormats.length];
    private static final String helpText;
    private Timer timer = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Epoch.this.showTimestamp();
        }
    });
    private JLabel topLabel = new JLabel("Enter timestamp or readable date:");
    private JTextField inputField = new JTextField(25);
    private JButton convertButton = new JButton("Convert");
    private JButton helpButton = new JButton("Help");
    private static final SimpleDateFormat OUTPUT_DATE_FORMAT;

    Epoch() {
        super("Epoch");
        this.constructUI();
        this.timer.start();
    }

    private void constructUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout(3, 3));
        jPanel.add((Component)this.topLabel, "North");
        jPanel.add((Component)this.inputField, "West");
        jPanel.add((Component)this.convertButton, "Center");
        this.convertButton.setToolTipText(helpText);
        this.convertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Epoch.this.convert();
            }
        });
        jPanel.add((Component)this.helpButton, "East");
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(Epoch.this.helpButton, helpText, "Epoch Help", 1);
            }
        });
        this.inputField.requestFocus();
        this.getRootPane().setDefaultButton(this.convertButton);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.pack();
        this.centerOnScreen();
        this.setVisible(true);
    }

    void centerOnScreen() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = this.getPreferredSize();
        double d = (dimension.getWidth() - dimension2.getWidth()) / 2.0;
        double d2 = (dimension.getHeight() - dimension2.getHeight()) / 2.0;
        this.setLocation((int)d, (int)d2);
    }

    private void convert() {
        String string = this.inputField.getText().trim();
        if (string.length() > 0) {
            try {
                long l = Long.parseLong(string);
                Date date = new Date(l * 1000L);
                this.formatDate(date);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    this.inputField.setText("" + this.parseDate(string));
                }
                catch (Exception exception) {
                    this.inputField.setText("Could not convert, sorry");
                }
            }
        }
    }

    private void showTimestamp() {
        long l = Util.getTime();
        this.setTitle(l + " seconds since epoch");
    }

    void formatDate(Date date) {
        this.inputField.setText(OUTPUT_DATE_FORMAT.format(date));
    }

    private long parseDate(String string) {
        for (SimpleDateFormat simpleDateFormat : parsers) {
            try {
                return Util.getTimestamp(simpleDateFormat.parse(string));
            }
            catch (ParseException parseException) {
            }
        }
        return new TimeParser(string).parse().getTimestamp();
    }

    public static void main(String[] stringArray) {
        new Epoch();
    }

    static {
        for (int i = 0; i < parsers.length; ++i) {
            Epoch.parsers[i] = new SimpleDateFormat(supportedFormats[i]);
            parsers[i].setLenient(true);
        }
        StringBuilder stringBuilder = new StringBuilder("<html><b>Supported input formats:</b><br>");
        for (String string : supportedFormats) {
            stringBuilder.append(string).append("<br>");
        }
        stringBuilder.append("<b>AT-style time specification</b><br>");
        stringBuilder.append("timestamp<br><br>");
        stringBuilder.append("Copyright 2010 Sasa Markovic and Mathias Bogaert. Licensed under the Apache License, Version 2.0.</html>");
        helpText = stringBuilder.toString();
        OUTPUT_DATE_FORMAT = new SimpleDateFormat("MM/dd/yy HH:mm:ss EEE");
    }
}

