/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.data;

import org.rrd4j.ConsolFun;
import org.rrd4j.data.Aggregates;
import org.rrd4j.data.DataProcessor;
import org.rrd4j.data.NonRrdSource;
import org.rrd4j.data.Source;

class SDef
extends Source
implements NonRrdSource {
    private String defName;
    private ConsolFun consolFun;
    private double value;

    SDef(String string, String string2, ConsolFun consolFun) {
        super(string);
        this.defName = string2;
        this.consolFun = consolFun;
    }

    String getDefName() {
        return this.defName;
    }

    ConsolFun getConsolFun() {
        return this.consolFun;
    }

    void setValue(double d) {
        this.value = d;
        int n = this.getTimestamps().length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
        }
        this.setValues(dArray);
    }

    @Override
    Aggregates getAggregates(long l, long l2) {
        Aggregates aggregates = new Aggregates();
        aggregates.max = aggregates.average = this.value;
        aggregates.min = aggregates.average;
        aggregates.last = aggregates.average;
        aggregates.first = aggregates.average;
        aggregates.total = this.value * (double)(l2 - l);
        return aggregates;
    }

    @Override
    public void calculate(long l, long l2, DataProcessor dataProcessor) {
        String string = this.getDefName();
        ConsolFun consolFun = this.getConsolFun();
        Source source = dataProcessor.getSource(string);
        double d = source.getAggregates(l, l2).getAggregate(consolFun);
        this.setValue(d);
    }
}

