/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.Font;
import java.awt.Paint;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphConstants;
import org.rrd4j.graph.TimeAxisSetting;

class TimeAxis
implements RrdGraphConstants {
    private static final TimeAxisSetting[] tickSettings = new TimeAxisSetting[]{new TimeAxisSetting(0L, 13, 30, 12, 5, 12, 5, 0, "HH:mm"), new TimeAxisSetting(2L, 12, 1, 12, 5, 12, 5, 0, "HH:mm"), new TimeAxisSetting(5L, 12, 2, 12, 10, 12, 10, 0, "HH:mm"), new TimeAxisSetting(10L, 12, 5, 12, 20, 12, 20, 0, "HH:mm"), new TimeAxisSetting(30L, 12, 10, 11, 1, 11, 1, 0, "HH:mm"), new TimeAxisSetting(60L, 12, 30, 11, 2, 11, 2, 0, "HH:mm"), new TimeAxisSetting(180L, 11, 1, 11, 6, 11, 6, 0, "HH:mm"), new TimeAxisSetting(600L, 11, 6, 5, 1, 5, 1, 86400, "EEE"), new TimeAxisSetting(1800L, 11, 12, 5, 1, 5, 2, 86400, "EEE"), new TimeAxisSetting(3600L, 5, 1, 3, 1, 3, 1, 604800, "'Week 'w"), new TimeAxisSetting(10800L, 3, 1, 2, 1, 3, 2, 604800, "'Week 'w"), new TimeAxisSetting(21600L, 2, 1, 2, 1, 2, 1, 2592000, "MMM"), new TimeAxisSetting(172800L, 2, 1, 2, 3, 2, 3, 2592000, "MMM"), new TimeAxisSetting(864000L, 1, 1, 1, 1, 1, 1, 31536000, "yy"), new TimeAxisSetting(-1L, 2, 0, 2, 0, 2, 0, 0, "")};
    private TimeAxisSetting tickSetting;
    private RrdGraph rrdGraph;
    private double secPerPix;
    private Calendar calendar;

    TimeAxis(RrdGraph rrdGraph) {
        this.rrdGraph = rrdGraph;
        this.secPerPix = (double)(rrdGraph.im.end - rrdGraph.im.start) / (double)rrdGraph.im.xsize;
        this.calendar = Calendar.getInstance(Locale.getDefault());
        this.calendar.setFirstDayOfWeek(rrdGraph.gdef.firstDayOfWeek);
    }

    void draw() {
        this.chooseTickSettings();
        if (this.tickSetting == null) {
            return;
        }
        this.drawMinor();
        this.drawMajor();
        this.drawLabels();
    }

    private void drawMinor() {
        if (!this.rrdGraph.gdef.noMinorGrid) {
            this.adjustStartingTime(this.tickSetting.minorUnit, this.tickSetting.minorUnitCount);
            Paint paint = this.rrdGraph.gdef.colors[4];
            int n = this.rrdGraph.im.yorigin;
            int n2 = n - this.rrdGraph.im.ysize;
            int n3 = this.getTimeShift();
            while (n3 <= 0) {
                if (n3 == 0) {
                    long l = this.calendar.getTime().getTime() / 1000L;
                    int n4 = this.rrdGraph.mapper.xtr(l);
                    this.rrdGraph.worker.drawLine(n4, n - 1, n4, n + 1, paint, TICK_STROKE);
                    this.rrdGraph.worker.drawLine(n4, n, n4, n2, paint, GRID_STROKE);
                }
                this.findNextTime(this.tickSetting.minorUnit, this.tickSetting.minorUnitCount);
                n3 = this.getTimeShift();
            }
        }
    }

    private void drawMajor() {
        this.adjustStartingTime(this.tickSetting.majorUnit, this.tickSetting.majorUnitCount);
        Paint paint = this.rrdGraph.gdef.colors[5];
        int n = this.rrdGraph.im.yorigin;
        int n2 = n - this.rrdGraph.im.ysize;
        int n3 = this.getTimeShift();
        while (n3 <= 0) {
            if (n3 == 0) {
                long l = this.calendar.getTime().getTime() / 1000L;
                int n4 = this.rrdGraph.mapper.xtr(l);
                this.rrdGraph.worker.drawLine(n4, n - 2, n4, n + 2, paint, TICK_STROKE);
                this.rrdGraph.worker.drawLine(n4, n, n4, n2, paint, GRID_STROKE);
            }
            this.findNextTime(this.tickSetting.majorUnit, this.tickSetting.majorUnitCount);
            n3 = this.getTimeShift();
        }
    }

    private void drawLabels() {
        String string = this.tickSetting.format.replaceAll("([^%]|^)%([^%t])", "$1%t$2");
        Font font = this.rrdGraph.gdef.smallFont;
        Paint paint = this.rrdGraph.gdef.colors[6];
        this.adjustStartingTime(this.tickSetting.labelUnit, this.tickSetting.labelUnitCount);
        int n = this.rrdGraph.im.yorigin + (int)this.rrdGraph.worker.getFontHeight(font) + 2;
        int n2 = this.getTimeShift();
        while (n2 <= 0) {
            int n3;
            int n4;
            String string2 = TimeAxis.formatLabel(string, this.calendar.getTime());
            long l = this.calendar.getTime().getTime() / 1000L;
            int n5 = this.rrdGraph.mapper.xtr(l);
            int n6 = n5 + ((n4 = this.rrdGraph.mapper.xtr(l + (long)this.tickSetting.labelSpan)) - n5 - (n3 = (int)this.rrdGraph.worker.getStringWidth(string2, font))) / 2;
            if (n6 >= this.rrdGraph.im.xorigin && n6 + n3 <= this.rrdGraph.im.xorigin + this.rrdGraph.im.xsize) {
                this.rrdGraph.worker.drawString(string2, n6, n, font, paint);
            }
            this.findNextTime(this.tickSetting.labelUnit, this.tickSetting.labelUnitCount);
            n2 = this.getTimeShift();
        }
    }

    private static String formatLabel(String string, Date date) {
        if (string.contains("%")) {
            return String.format(string, date);
        }
        return new SimpleDateFormat(string).format(date);
    }

    private void findNextTime(int n, int n2) {
        switch (n) {
            case 13: {
                this.calendar.add(13, n2);
                break;
            }
            case 12: {
                this.calendar.add(12, n2);
                break;
            }
            case 11: {
                this.calendar.add(11, n2);
                break;
            }
            case 5: {
                this.calendar.add(5, n2);
                break;
            }
            case 3: {
                this.calendar.add(5, 7 * n2);
                break;
            }
            case 2: {
                this.calendar.add(2, n2);
                break;
            }
            case 1: {
                this.calendar.add(1, n2);
            }
        }
    }

    private int getTimeShift() {
        long l = this.calendar.getTime().getTime() / 1000L;
        return l < this.rrdGraph.im.start ? -1 : (l > this.rrdGraph.im.end ? 1 : 0);
    }

    private void adjustStartingTime(int n, int n2) {
        this.calendar.setTime(new Date(this.rrdGraph.im.start * 1000L));
        switch (n) {
            case 13: {
                this.calendar.add(13, -(this.calendar.get(13) % n2));
                break;
            }
            case 12: {
                this.calendar.set(13, 0);
                this.calendar.add(12, -(this.calendar.get(12) % n2));
                break;
            }
            case 11: {
                this.calendar.set(13, 0);
                this.calendar.set(12, 0);
                this.calendar.add(11, -(this.calendar.get(11) % n2));
                break;
            }
            case 5: {
                this.calendar.set(13, 0);
                this.calendar.set(12, 0);
                this.calendar.set(11, 0);
                break;
            }
            case 3: {
                this.calendar.set(13, 0);
                this.calendar.set(12, 0);
                this.calendar.set(11, 0);
                int n3 = this.calendar.get(7) - this.calendar.getFirstDayOfWeek();
                if (n3 < 0) {
                    n3 += 7;
                }
                this.calendar.add(5, -n3);
                break;
            }
            case 2: {
                this.calendar.set(13, 0);
                this.calendar.set(12, 0);
                this.calendar.set(11, 0);
                this.calendar.set(5, 1);
                this.calendar.add(2, -(this.calendar.get(2) % n2));
                break;
            }
            case 1: {
                this.calendar.set(13, 0);
                this.calendar.set(12, 0);
                this.calendar.set(11, 0);
                this.calendar.set(5, 1);
                this.calendar.set(2, 0);
                this.calendar.add(1, -(this.calendar.get(1) % n2));
            }
        }
    }

    private void chooseTickSettings() {
        if (this.rrdGraph.gdef.timeAxisSetting != null) {
            this.tickSetting = new TimeAxisSetting(this.rrdGraph.gdef.timeAxisSetting);
        } else {
            int n = 0;
            while (TimeAxis.tickSettings[n].secPerPix >= 0L && this.secPerPix > (double)TimeAxis.tickSettings[n].secPerPix) {
                this.tickSetting = tickSettings[n];
                ++n;
            }
        }
    }
}

