/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.inspector;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.ArcDef;
import org.rrd4j.inspector.Util;

class EditArchiveDialog
extends JDialog {
    private static final int FIELD_SIZE = 20;
    private static final String TITLE_NEW = "New archive";
    private static final String TITLE_EDIT = "Edit archive";
    private JLabel consolFunLabel = new JLabel("Consolidation function: ");
    private JLabel xffLabel = new JLabel("X-files factor: ");
    private JLabel stepsLabel = new JLabel("Steps: ");
    private JLabel rowsLabel = new JLabel("Rows: ");
    private JComboBox consolFunCombo = new JComboBox();
    private JTextField xffField = new JTextField(20);
    private JTextField stepsField = new JTextField(20);
    private JTextField rowsField = new JTextField(20);
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private ArcDef arcDef;

    EditArchiveDialog(Frame frame, ArcDef arcDef) {
        super(frame, arcDef == null ? TITLE_NEW : TITLE_EDIT, true);
        this.constructUI(arcDef);
        this.pack();
        Util.centerOnScreen(this);
        this.setVisible(true);
    }

    private void constructUI(ArcDef arcDef) {
        for (ConsolFun consolFun : ConsolFun.values()) {
            this.consolFunCombo.addItem(consolFun);
        }
        this.consolFunCombo.setSelectedIndex(0);
        if (arcDef == null) {
            this.xffField.setText("0.5");
        } else {
            this.consolFunCombo.setSelectedItem((Object)arcDef.getConsolFun());
            this.consolFunCombo.setEnabled(false);
            this.xffField.setText("" + arcDef.getXff());
            this.stepsField.setText("" + arcDef.getSteps());
            this.stepsField.setEnabled(false);
            this.rowsField.setText("" + arcDef.getRows());
        }
        JPanel jPanel = (JPanel)this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.consolFunLabel, gridBagConstraints);
        jPanel.add(this.consolFunLabel);
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.xffLabel, gridBagConstraints);
        jPanel.add(this.xffLabel);
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.stepsLabel, gridBagConstraints);
        jPanel.add(this.stepsLabel);
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.rowsLabel, gridBagConstraints);
        jPanel.add(this.rowsLabel);
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.okButton.setPreferredSize(this.cancelButton.getPreferredSize());
        jPanel.add(this.okButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.consolFunCombo, gridBagConstraints);
        jPanel.add(this.consolFunCombo);
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.xffField, gridBagConstraints);
        jPanel.add(this.xffField);
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.stepsField, gridBagConstraints);
        jPanel.add(this.stepsField);
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.rowsField, gridBagConstraints);
        jPanel.add(this.rowsField);
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        jPanel.add(this.cancelButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditArchiveDialog.this.ok();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditArchiveDialog.this.cancel();
            }
        });
        this.setDefaultCloseOperation(2);
    }

    private void ok() {
        this.arcDef = this.createArcDef();
        if (this.arcDef != null) {
            this.close();
        }
    }

    private void close() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void cancel() {
        this.close();
    }

    private ArcDef createArcDef() {
        int n;
        int n2;
        double d;
        ConsolFun consolFun = (ConsolFun)((Object)this.consolFunCombo.getSelectedItem());
        try {
            d = Double.parseDouble(this.xffField.getText());
            if (d < 0.0 || d >= 1.0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            Util.error((Component)this, "X-files factor must be a number not less than 0.0 and less than 1.0");
            return null;
        }
        try {
            n2 = Integer.parseInt(this.stepsField.getText());
            if (n2 <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            Util.error((Component)this, "Number of steps must be a positive integer");
            return null;
        }
        try {
            n = Integer.parseInt(this.rowsField.getText());
            if (n <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            Util.error((Component)this, "Number of rows must be a positive integer");
            return null;
        }
        try {
            return new ArcDef(consolFun, d, n2, n);
        }
        catch (Exception exception) {
            Util.error((Component)this, exception);
            return null;
        }
    }

    ArcDef getArcDef() {
        return this.arcDef;
    }
}

