/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.inspector;

import java.io.File;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.rrd4j.core.Header;
import org.rrd4j.core.RrdDb;
import org.rrd4j.inspector.Util;

class HeaderTableModel
extends AbstractTableModel {
    private static final Object[] DESCRIPTIONS = new Object[]{"path", "signature", "step", "last timestamp", "datasources", "archives", "size"};
    private static final String[] COLUMN_NAMES = new String[]{"description", "value"};
    private Object[] values;

    HeaderTableModel() {
    }

    @Override
    public int getRowCount() {
        return DESCRIPTIONS.length;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return DESCRIPTIONS[n];
        }
        if (n2 == 1) {
            if (this.values != null) {
                return this.values[n];
            }
            return "--";
        }
        return null;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFile(File file) {
        try {
            this.values = null;
            String string = file.getAbsolutePath();
            RrdDb rrdDb = new RrdDb(string, true);
            try {
                Header header = rrdDb.getHeader();
                String string2 = header.getSignature();
                String string3 = "" + header.getStep();
                String string4 = header.getLastUpdateTime() + " [" + new Date(header.getLastUpdateTime() * 1000L) + "]";
                String string5 = "" + header.getDsCount();
                String string6 = "" + header.getArcCount();
                String string7 = rrdDb.getRrdBackend().getLength() + " bytes";
                this.values = new Object[]{string, string2, string3, string4, string5, string6, string7};
            }
            finally {
                rrdDb.close();
            }
            this.fireTableDataChanged();
        }
        catch (Exception exception) {
            Util.error(null, exception);
        }
    }
}

