/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.io.IOException;
import org.rrd4j.core.RrdByteArrayBackend;

public class RrdMongoDBBackend
extends RrdByteArrayBackend {
    private final DBCollection rrdCollection;
    private volatile boolean dirty = false;

    public RrdMongoDBBackend(String string, DBCollection dBCollection) {
        super(string);
        this.rrdCollection = dBCollection;
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put("path", (Object)string);
        DBObject dBObject = dBCollection.findOne((DBObject)basicDBObject);
        if (dBObject != null) {
            this.buffer = (byte[])dBObject.get("rrd");
        }
    }

    @Override
    protected synchronized void write(long l, byte[] byArray) throws IOException {
        super.write(l, byArray);
        this.dirty = true;
    }

    @Override
    public void close() throws IOException {
        if (this.dirty) {
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.put("path", (Object)this.getPath());
            DBObject dBObject = this.rrdCollection.findOne((DBObject)basicDBObject);
            if (dBObject == null) {
                dBObject = new BasicDBObject();
                dBObject.put("path", (Object)this.getPath());
            }
            dBObject.put("rrd", (Object)this.buffer);
            this.rrdCollection.save(dBObject);
        }
    }
}

