/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.io.IOException;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdMongoDBBackend;

public class RrdMongoDBBackendFactory
extends RrdBackendFactory {
    private final DBCollection rrdCollection;

    public RrdMongoDBBackendFactory(DBCollection dBCollection) {
        this.rrdCollection = dBCollection;
        dBCollection.ensureIndex((DBObject)new BasicDBObject("path", (Object)1));
        RrdBackendFactory.registerAndSetAsDefaultFactory(this);
    }

    @Override
    protected RrdBackend open(String string, boolean bl) throws IOException {
        return new RrdMongoDBBackend(string, this.rrdCollection);
    }

    @Override
    protected boolean exists(String string) throws IOException {
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put("path", (Object)string);
        return this.rrdCollection.findOne((DBObject)basicDBObject) != null;
    }

    @Override
    protected boolean shouldValidateHeader(String string) throws IOException {
        return false;
    }

    @Override
    public String getName() {
        return "MONGODB";
    }
}

