/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.DataImporter;
import org.rrd4j.core.Util;
import org.rrd4j.core.jrrd.RRDatabase;

class RrdToolReader
extends DataImporter {
    private RRDatabase rrd;

    RrdToolReader(String string) throws IOException {
        this.rrd = new RRDatabase(string);
    }

    @Override
    String getVersion() {
        return this.rrd.getHeader().getVersion();
    }

    @Override
    long getLastUpdateTime() {
        return Util.getTimestamp(this.rrd.getLastUpdate());
    }

    @Override
    long getStep() {
        return this.rrd.getHeader().getPDPStep();
    }

    @Override
    int getDsCount() {
        return this.rrd.getHeader().getDSCount();
    }

    @Override
    int getArcCount() throws IOException {
        return this.rrd.getNumArchives();
    }

    @Override
    String getDsName(int n) {
        return this.rrd.getDataSource(n).getName();
    }

    @Override
    String getDsType(int n) {
        return this.rrd.getDataSource(n).getType().toString();
    }

    @Override
    long getHeartbeat(int n) {
        return this.rrd.getDataSource(n).getMinimumHeartbeat();
    }

    @Override
    double getMinValue(int n) {
        return this.rrd.getDataSource(n).getMinimum();
    }

    @Override
    double getMaxValue(int n) {
        return this.rrd.getDataSource(n).getMaximum();
    }

    @Override
    double getLastValue(int n) {
        String string = this.rrd.getDataSource(n).getPDPStatusBlock().getLastReading();
        return Util.parseDouble(string);
    }

    @Override
    double getAccumValue(int n) {
        return this.rrd.getDataSource(n).getPDPStatusBlock().getValue();
    }

    @Override
    long getNanSeconds(int n) {
        return this.rrd.getDataSource(n).getPDPStatusBlock().getUnknownSeconds();
    }

    @Override
    ConsolFun getConsolFun(int n) {
        return ConsolFun.valueOf(this.rrd.getArchive(n).getType().toString());
    }

    @Override
    double getXff(int n) {
        return this.rrd.getArchive(n).getXff();
    }

    @Override
    int getSteps(int n) {
        return this.rrd.getArchive(n).getPdpCount();
    }

    @Override
    int getRows(int n) throws IOException {
        return this.rrd.getArchive(n).getRowCount();
    }

    @Override
    double getStateAccumValue(int n, int n2) throws IOException {
        return this.rrd.getArchive(n).getCDPStatusBlock(n2).getValue();
    }

    @Override
    int getStateNanSteps(int n, int n2) throws IOException {
        return this.rrd.getArchive(n).getCDPStatusBlock(n2).getUnknownDatapoints();
    }

    @Override
    double[] getValues(int n, int n2) throws IOException {
        return this.rrd.getArchive(n).getValues()[n2];
    }

    @Override
    void release() throws IOException {
        if (this.rrd != null) {
            this.rrd.close();
            this.rrd = null;
        }
    }

    protected void finalize() throws Throwable {
        this.release();
    }
}

