/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.io.IOException;
import org.rrd4j.core.jrrd.Constants;
import org.rrd4j.core.jrrd.RRDFile;
import org.rrd4j.core.jrrd.UnivalArray;

public class Header
implements Constants {
    private static final double FLOAT_COOKIE = 8.642135E130;
    private static final long offset = 0L;
    private long size;
    String version = "UNDEF";
    private int iVersion = -1;
    int dsCount;
    int rraCount;
    int pdpStep;

    Header(RRDFile rRDFile) throws IOException {
        if (!rRDFile.readString(4).equals("RRD")) {
            throw new IOException("Invalid COOKIE");
        }
        this.version = rRDFile.readString(5);
        try {
            this.iVersion = Integer.parseInt(this.version);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("Unsupported RRD version (" + this.version + ")");
        }
        if (this.iVersion > 3) {
            throw new RuntimeException("Unsupported RRD version (" + this.version + ")");
        }
        rRDFile.align();
        double d = rRDFile.readDouble();
        if (d != 8.642135E130) {
            throw new RuntimeException("This RRD was created on another architecture");
        }
        this.dsCount = rRDFile.readLong();
        this.rraCount = rRDFile.readLong();
        this.pdpStep = rRDFile.readLong();
        rRDFile.align();
        UnivalArray univalArray = rRDFile.getUnivalArray(10);
        this.size = rRDFile.getFilePointer() - 0L;
    }

    public String getVersion() {
        return this.version;
    }

    public int getVersionAsInt() {
        return this.iVersion;
    }

    public int getDSCount() {
        return this.dsCount;
    }

    public int getRRACount() {
        return this.rraCount;
    }

    public int getPDPStep() {
        return this.pdpStep;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[Header: OFFSET=0x00, SIZE=0x");
        stringBuilder.append(Long.toHexString(this.size));
        stringBuilder.append(", version=");
        stringBuilder.append(this.version);
        stringBuilder.append(", dsCount=");
        stringBuilder.append(this.dsCount);
        stringBuilder.append(", rraCount=");
        stringBuilder.append(this.rraCount);
        stringBuilder.append(", pdpStep=");
        stringBuilder.append(this.pdpStep);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

