/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.io.IOException;
import org.rrd4j.core.jrrd.RRDFile;
import org.rrd4j.core.jrrd.UnivalArray;

public class PDPStatusBlock {
    private long offset;
    private long size;
    String lastReading;
    int unknownSeconds;
    double value;

    PDPStatusBlock(RRDFile rRDFile) throws IOException {
        this.offset = rRDFile.getFilePointer();
        this.lastReading = rRDFile.readString(30);
        UnivalArray univalArray = rRDFile.getUnivalArray(10);
        this.unknownSeconds = (int)univalArray.getLong(pdp_par_en.PDP_unkn_sec_cnt);
        this.value = univalArray.getDouble(pdp_par_en.PDP_val);
        this.size = rRDFile.getFilePointer() - this.offset;
    }

    public String getLastReading() {
        return this.lastReading;
    }

    public double getValue() {
        return this.value;
    }

    public int getUnknownSeconds() {
        return this.unknownSeconds;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[PDPStatus: OFFSET=0x");
        stringBuilder.append(Long.toHexString(this.offset));
        stringBuilder.append(", SIZE=0x");
        stringBuilder.append(Long.toHexString(this.size));
        stringBuilder.append(", lastReading=");
        stringBuilder.append(this.lastReading);
        stringBuilder.append(", unknownSeconds=");
        stringBuilder.append(this.unknownSeconds);
        stringBuilder.append(", value=");
        stringBuilder.append(this.value);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static enum pdp_par_en {
        PDP_unkn_sec_cnt,
        PDP_val;

    }
}

