/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.timespec;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.rrd4j.core.Util;

public class TimeSpec {
    static final int TYPE_ABSOLUTE = 0;
    static final int TYPE_START = 1;
    static final int TYPE_END = 2;
    int type = 0;
    int year;
    int month;
    int day;
    int hour;
    int min;
    int sec;
    int wday;
    int dyear;
    int dmonth;
    int dday;
    int dhour;
    int dmin;
    int dsec;
    String dateString;
    TimeSpec context;

    TimeSpec(String string) {
        this.dateString = string;
    }

    void localtime(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date(l * 1000L));
        this.year = gregorianCalendar.get(1) - 1900;
        this.month = gregorianCalendar.get(2);
        this.day = gregorianCalendar.get(5);
        this.hour = gregorianCalendar.get(11);
        this.min = gregorianCalendar.get(12);
        this.sec = gregorianCalendar.get(13);
        this.wday = gregorianCalendar.get(7) - 1;
    }

    GregorianCalendar getTime() {
        GregorianCalendar gregorianCalendar;
        if (this.type == 0) {
            gregorianCalendar = new GregorianCalendar(this.year + 1900, this.month, this.day, this.hour, this.min, this.sec);
        } else if (this.context != null && this.context.type == 0) {
            gregorianCalendar = this.context.getTime();
        } else {
            throw new IllegalStateException("Relative times like '" + this.dateString + "' require proper absolute context to be evaluated");
        }
        gregorianCalendar.add(1, this.dyear);
        gregorianCalendar.add(2, this.dmonth);
        gregorianCalendar.add(5, this.dday);
        gregorianCalendar.add(11, this.dhour);
        gregorianCalendar.add(12, this.dmin);
        gregorianCalendar.add(13, this.dsec);
        return gregorianCalendar;
    }

    public long getTimestamp() {
        return Util.getTimestamp(this.getTime());
    }

    String dump() {
        return (this.type == 0 ? "ABSTIME" : (this.type == 1 ? "START" : "END")) + ": " + this.year + "/" + this.month + "/" + this.day + "/" + this.hour + "/" + this.min + "/" + this.sec + " (" + this.dyear + "/" + this.dmonth + "/" + this.dday + "/" + this.dhour + "/" + this.dmin + "/" + this.dsec + ")";
    }

    public static Calendar[] getTimes(TimeSpec timeSpec, TimeSpec timeSpec2) {
        if (timeSpec.type == 1 || timeSpec2.type == 2) {
            throw new IllegalArgumentException("Recursive time specifications not allowed");
        }
        timeSpec.context = timeSpec2;
        timeSpec2.context = timeSpec;
        return new Calendar[]{timeSpec.getTime(), timeSpec2.getTime()};
    }

    public static long[] getTimestamps(TimeSpec timeSpec, TimeSpec timeSpec2) {
        Calendar[] calendarArray = TimeSpec.getTimes(timeSpec, timeSpec2);
        return new long[]{Util.getTimestamp(calendarArray[0]), Util.getTimestamp(calendarArray[1])};
    }
}

