/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.Font;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.Util;
import org.rrd4j.data.Plottable;
import org.rrd4j.graph.Area;
import org.rrd4j.graph.CDef;
import org.rrd4j.graph.CommentText;
import org.rrd4j.graph.Def;
import org.rrd4j.graph.HRule;
import org.rrd4j.graph.LegendText;
import org.rrd4j.graph.Line;
import org.rrd4j.graph.PDef;
import org.rrd4j.graph.PercentileDef;
import org.rrd4j.graph.PlotElement;
import org.rrd4j.graph.PrintText;
import org.rrd4j.graph.RrdGraphConstants;
import org.rrd4j.graph.SDef;
import org.rrd4j.graph.Source;
import org.rrd4j.graph.SourcedPlotElement;
import org.rrd4j.graph.Stack;
import org.rrd4j.graph.TDef;
import org.rrd4j.graph.TimeAxisSetting;
import org.rrd4j.graph.VRule;
import org.rrd4j.graph.ValueAxisSetting;

public class RrdGraphDef
implements RrdGraphConstants {
    boolean poolUsed = false;
    boolean antiAliasing = false;
    boolean textAntiAliasing = false;
    String filename = "-";
    long startTime;
    long endTime;
    TimeAxisSetting timeAxisSetting = null;
    ValueAxisSetting valueAxisSetting = null;
    boolean altYGrid = false;
    boolean noMinorGrid = false;
    boolean altYMrtg = false;
    boolean altAutoscale = false;
    boolean altAutoscaleMax = false;
    int unitsExponent = Integer.MAX_VALUE;
    int unitsLength = 9;
    String verticalLabel = null;
    int width = 400;
    int height = 100;
    boolean interlaced = false;
    String imageInfo = null;
    String imageFormat = "gif";
    float imageQuality = 0.8f;
    String backgroundImage = null;
    String overlayImage = null;
    String unit = null;
    boolean lazy = false;
    double minValue = Double.NaN;
    double maxValue = Double.NaN;
    boolean rigid = false;
    double base = 1000.0;
    boolean logarithmic = false;
    Paint[] colors = new Paint[]{DEFAULT_CANVAS_COLOR, DEFAULT_BACK_COLOR, DEFAULT_SHADEA_COLOR, DEFAULT_SHADEB_COLOR, DEFAULT_GRID_COLOR, DEFAULT_MGRID_COLOR, DEFAULT_FONT_COLOR, DEFAULT_FRAME_COLOR, DEFAULT_ARROW_COLOR};
    boolean noLegend = false;
    boolean onlyGraph = false;
    boolean forceRulesLegend = false;
    String title = null;
    long step = 0L;
    Font smallFont = RrdGraphConstants.DEFAULT_SMALL_FONT;
    Font largeFont = RrdGraphConstants.DEFAULT_LARGE_FONT;
    boolean drawXGrid = true;
    boolean drawYGrid = true;
    int firstDayOfWeek = FIRST_DAY_OF_WEEK;
    boolean showSignature = true;
    final List<Source> sources = new ArrayList<Source>();
    final List<CommentText> comments = new ArrayList<CommentText>();
    final List<PlotElement> plotElements = new ArrayList<PlotElement>();

    public RrdGraphDef() {
        this.setTimeSpan(Util.getTimestamps("end-1d", "now"));
    }

    public void setStartTime(long l) {
        this.startTime = l;
        if (l <= 0L) {
            this.startTime += Util.getTime();
        }
    }

    public void setEndTime(long l) {
        this.endTime = l;
        if (l <= 0L) {
            this.endTime += Util.getTime();
        }
    }

    public void setTimeSpan(long l, long l2) {
        this.setStartTime(l);
        this.setEndTime(l2);
    }

    public void setTimeSpan(long[] lArray) {
        this.setTimeSpan(lArray[0], lArray[lArray.length - 1]);
    }

    public void setPoolUsed(boolean bl) {
        this.poolUsed = bl;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public void setTimeAxis(int n, int n2, int n3, int n4, int n5, int n6, int n7, String string) {
        this.timeAxisSetting = new TimeAxisSetting(n, n2, n3, n4, n5, n6, n7, string);
    }

    public void setValueAxis(double d, int n) {
        this.valueAxisSetting = new ValueAxisSetting(d, n);
    }

    public void setAltYGrid(boolean bl) {
        this.altYGrid = bl;
    }

    public void setNoMinorGrid(boolean bl) {
        this.noMinorGrid = bl;
    }

    public void setAltYMrtg(boolean bl) {
        this.altYMrtg = bl;
    }

    public void setAltAutoscale(boolean bl) {
        this.altAutoscale = bl;
    }

    public void setAltAutoscaleMax(boolean bl) {
        this.altAutoscaleMax = bl;
    }

    public void setUnitsExponent(int n) {
        this.unitsExponent = n;
    }

    public void setUnitsLength(int n) {
        this.unitsLength = n;
    }

    public void setVerticalLabel(String string) {
        this.verticalLabel = string;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setInterlaced(boolean bl) {
        this.interlaced = bl;
    }

    public void setImageInfo(String string) {
        this.imageInfo = string;
    }

    public void setImageFormat(String string) {
        this.imageFormat = string;
    }

    public void setBackgroundImage(String string) {
        this.backgroundImage = string;
    }

    public void setOverlayImage(String string) {
        this.overlayImage = string;
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    public void setLazy(boolean bl) {
        this.lazy = bl;
    }

    public void setMinValue(double d) {
        this.minValue = d;
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
    }

    public void setRigid(boolean bl) {
        this.rigid = bl;
    }

    public void setBase(double d) {
        this.base = d;
    }

    public void setLogarithmic(boolean bl) {
        this.logarithmic = bl;
    }

    public void setColor(int n, Paint paint) {
        if (n < 0 || n >= this.colors.length) {
            throw new IllegalArgumentException("Invalid color index specified: " + n);
        }
        this.colors[n] = paint;
    }

    public void setColor(String string, Paint paint) {
        this.setColor(RrdGraphDef.getColorTagByName(string), paint);
    }

    private static int getColorTagByName(String string) {
        for (int i = 0; i < COLOR_NAMES.length; ++i) {
            if (!COLOR_NAMES[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        throw new IllegalArgumentException("Unknown color name specified: " + string);
    }

    public void setNoLegend(boolean bl) {
        this.noLegend = bl;
    }

    public void setOnlyGraph(boolean bl) {
        this.onlyGraph = bl;
    }

    public void setForceRulesLegend(boolean bl) {
        this.forceRulesLegend = bl;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setStep(long l) {
        this.step = l;
    }

    public void setSmallFont(Font font) {
        this.smallFont = font;
    }

    public void setLargeFont(Font font) {
        this.largeFont = font;
    }

    public void datasource(String string, String string2, String string3, ConsolFun consolFun) {
        this.sources.add(new Def(string, string2, string3, consolFun));
    }

    public void datasource(String string, String string2, String string3, ConsolFun consolFun, String string4) {
        this.sources.add(new Def(string, string2, string3, consolFun, string4));
    }

    public void datasource(String string, String string2) {
        this.sources.add(new CDef(string, string2));
    }

    public void datasource(String string, String string2, ConsolFun consolFun) {
        this.sources.add(new SDef(string, string2, consolFun));
    }

    public void datasource(String string, Plottable plottable) {
        this.sources.add(new PDef(string, plottable));
    }

    public void datasource(String string, FetchData fetchData) {
        this.sources.add(new TDef(string, fetchData));
    }

    public void percentile(String string, String string2) {
        this.percentile(string, string2, 95.0);
    }

    public void percentile(String string, String string2, double d) {
        this.sources.add(new PercentileDef(string, string2, d));
    }

    public void print(String string, ConsolFun consolFun, String string2) {
        this.comments.add(new PrintText(string, consolFun, string2, false));
    }

    public void gprint(String string, ConsolFun consolFun, String string2) {
        this.comments.add(new PrintText(string, consolFun, string2, true));
    }

    public void comment(String string) {
        this.comments.add(new CommentText(string));
    }

    public void hrule(double d, Paint paint) {
        this.hrule(d, paint, null, 1.0f);
    }

    public void hrule(double d, Paint paint, String string) {
        this.hrule(d, paint, string, 1.0f);
    }

    public void hrule(double d, Paint paint, String string, float f) {
        LegendText legendText = new LegendText(paint, string);
        this.comments.add(legendText);
        this.plotElements.add(new HRule(d, paint, legendText, f));
    }

    public void vrule(long l, Paint paint) {
        this.vrule(l, paint, null, 1.0f);
    }

    public void vrule(long l, Paint paint, String string) {
        this.vrule(l, paint, string, 1.0f);
    }

    public void vrule(long l, Paint paint, String string, float f) {
        LegendText legendText = new LegendText(paint, string);
        this.comments.add(legendText);
        this.plotElements.add(new VRule(l, paint, legendText, f));
    }

    public void line(String string, Paint paint) {
        this.line(string, paint, null, 1.0f);
    }

    public void line(String string, Paint paint, String string2) {
        this.line(string, paint, string2, 1.0f);
    }

    public void line(String string, Paint paint, float f) {
        this.line(string, paint, null, f);
    }

    public void line(String string, Paint paint, String string2, float f) {
        if (string2 != null) {
            this.comments.add(new LegendText(paint, string2));
        }
        this.plotElements.add(new Line(string, paint, f));
    }

    public void area(String string, Paint paint) {
        this.area(string, paint, null);
    }

    public void area(String string, Paint paint, String string2) {
        if (string2 != null) {
            this.comments.add(new LegendText(paint, string2));
        }
        this.plotElements.add(new Area(string, paint));
    }

    public void stack(String string, Paint paint) {
        this.stack(string, paint, null);
    }

    public void stack(String string, Paint paint, String string2) {
        SourcedPlotElement sourcedPlotElement = null;
        for (int i = this.plotElements.size() - 1; i >= 0; --i) {
            PlotElement plotElement = this.plotElements.get(i);
            if (!(plotElement instanceof SourcedPlotElement)) continue;
            sourcedPlotElement = (SourcedPlotElement)plotElement;
            break;
        }
        if (sourcedPlotElement == null) {
            throw new IllegalArgumentException("You have to stack graph onto something (line or area)");
        }
        if (string2 != null) {
            this.comments.add(new LegendText(paint, string2));
        }
        this.plotElements.add(new Stack(sourcedPlotElement, string, paint));
    }

    public void setDrawXGrid(boolean bl) {
        this.drawXGrid = bl;
    }

    public void setDrawYGrid(boolean bl) {
        this.drawYGrid = bl;
    }

    public void setImageQuality(float f) {
        this.imageQuality = f;
    }

    public void setAntiAliasing(boolean bl) {
        this.antiAliasing = bl;
    }

    public void setTextAntiAliasing(boolean bl) {
        this.textAntiAliasing = bl;
    }

    public void setShowSignature(boolean bl) {
        this.showSignature = bl;
    }

    public void setFirstDayOfWeek(int n) {
        this.firstDayOfWeek = n;
    }

    int printStatementCount() {
        int n = 0;
        for (CommentText commentText : this.comments) {
            if (!(commentText instanceof PrintText) || !commentText.isPrint()) continue;
            ++n;
        }
        return n;
    }

    boolean shouldPlot() {
        if (this.plotElements.size() > 0) {
            return true;
        }
        for (CommentText commentText : this.comments) {
            if (!commentText.isValidGraphElement()) continue;
            return true;
        }
        return false;
    }
}

