/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import org.rrd4j.core.Archive;
import org.rrd4j.core.Header;
import org.rrd4j.core.RrdAllocator;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdDouble;
import org.rrd4j.core.RrdLong;
import org.rrd4j.core.RrdUpdater;
import org.rrd4j.core.Util;
import org.rrd4j.core.XmlWriter;

public class ArcState
implements RrdUpdater {
    private Archive parentArc;
    private RrdDouble accumValue;
    private RrdLong nanSteps;

    ArcState(Archive archive, boolean bl) throws IOException {
        this.parentArc = archive;
        this.accumValue = new RrdDouble(this);
        this.nanSteps = new RrdLong(this);
        if (bl) {
            Header header = archive.getParentDb().getHeader();
            long l = header.getStep();
            long l2 = header.getLastUpdateTime();
            long l3 = archive.getArcStep();
            long l4 = (Util.normalize(l2, l) - Util.normalize(l2, l3)) / l;
            this.accumValue.set(Double.NaN);
            this.nanSteps.set(l4);
        }
    }

    String dump() throws IOException {
        return "accumValue:" + this.accumValue.get() + " nanSteps:" + this.nanSteps.get() + "\n";
    }

    void setNanSteps(long l) throws IOException {
        this.nanSteps.set(l);
    }

    public long getNanSteps() throws IOException {
        return this.nanSteps.get();
    }

    void setAccumValue(double d) throws IOException {
        this.accumValue.set(d);
    }

    public double getAccumValue() throws IOException {
        return this.accumValue.get();
    }

    public Archive getParent() {
        return this.parentArc;
    }

    void appendXml(XmlWriter xmlWriter) throws IOException {
        xmlWriter.startTag("ds");
        xmlWriter.writeTag("value", this.accumValue.get());
        xmlWriter.writeTag("unknown_datapoints", this.nanSteps.get());
        xmlWriter.closeTag();
    }

    @Override
    public void copyStateTo(RrdUpdater rrdUpdater) throws IOException {
        if (!(rrdUpdater instanceof ArcState)) {
            throw new IllegalArgumentException("Cannot copy ArcState object to " + rrdUpdater.getClass().getName());
        }
        ArcState arcState = (ArcState)rrdUpdater;
        arcState.accumValue.set(this.accumValue.get());
        arcState.nanSteps.set(this.nanSteps.get());
    }

    @Override
    public RrdBackend getRrdBackend() {
        return this.parentArc.getRrdBackend();
    }

    @Override
    public RrdAllocator getRrdAllocator() {
        return this.parentArc.getRrdAllocator();
    }
}

