/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.util.Set;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.RrdDb;

public class FetchRequest {
    private RrdDb parentDb;
    private ConsolFun consolFun;
    private long fetchStart;
    private long fetchEnd;
    private long resolution;
    private String[] filter;

    FetchRequest(RrdDb rrdDb, ConsolFun consolFun, long l, long l2, long l3) {
        if (consolFun == null) {
            throw new IllegalArgumentException("Null consolidation function in fetch request");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Invalid start time in fetch request: " + l);
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("Invalid end time in fetch request: " + l2);
        }
        if (l > l2) {
            throw new IllegalArgumentException("Invalid start/end time in fetch request: " + l + " > " + l2);
        }
        if (l3 <= 0L) {
            throw new IllegalArgumentException("Invalid resolution in fetch request: " + l3);
        }
        this.parentDb = rrdDb;
        this.consolFun = consolFun;
        this.fetchStart = l;
        this.fetchEnd = l2;
        this.resolution = l3;
    }

    public void setFilter(String ... stringArray) {
        this.filter = stringArray;
    }

    public void setFilter(Set<String> set) {
        this.filter = set.toArray(new String[set.size()]);
    }

    public void setFilter(String string) {
        String[] stringArray;
        if (string == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        this.filter = stringArray;
    }

    public String[] getFilter() {
        return this.filter;
    }

    public ConsolFun getConsolFun() {
        return this.consolFun;
    }

    public long getFetchStart() {
        return this.fetchStart;
    }

    public long getFetchEnd() {
        return this.fetchEnd;
    }

    public long getResolution() {
        return this.resolution;
    }

    public String dump() {
        return "fetch \"" + this.parentDb.getRrdBackend().getPath() + "\" " + (Object)((Object)this.consolFun) + " --start " + this.fetchStart + " --end " + this.fetchEnd + (this.resolution > 1L ? " --resolution " + this.resolution : "");
    }

    String getRrdToolCommand() {
        return this.dump();
    }

    public FetchData fetchData() throws IOException {
        return this.parentDb.fetchData(this);
    }

    public RrdDb getParentDb() {
        return this.parentDb;
    }
}

