/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import org.rrd4j.core.RrdPrimitive;
import org.rrd4j.core.RrdUpdater;

class RrdDoubleArray
extends RrdPrimitive {
    private int length;

    RrdDoubleArray(RrdUpdater rrdUpdater, int n) throws IOException {
        super(rrdUpdater, 2, n, false);
        this.length = n;
    }

    void set(int n, double d) throws IOException {
        this.set(n, d, 1);
    }

    void set(int n, double d, int n2) throws IOException {
        assert (n + n2 <= this.length) : "Invalid robin index supplied: index=" + n + ", count=" + n2 + ", length=" + this.length;
        this.writeDouble(n, d, n2);
    }

    double get(int n) throws IOException {
        assert (n < this.length) : "Invalid index supplied: " + n + ", length=" + this.length;
        return this.readDouble(n);
    }

    double[] get(int n, int n2) throws IOException {
        assert (n + n2 <= this.length) : "Invalid index/count supplied: " + n + "/" + n2 + " (length=" + this.length + ")";
        return this.readDouble(n, n2);
    }
}

