/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.File;
import java.io.IOException;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.DataImporter;
import org.rrd4j.core.Util;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class XmlReader
extends DataImporter {
    private Element root;
    private Node[] dsNodes;
    private Node[] arcNodes;

    XmlReader(String string) throws IOException {
        this.root = Util.Xml.getRootElement(new File(string));
        this.dsNodes = Util.Xml.getChildNodes(this.root, "ds");
        this.arcNodes = Util.Xml.getChildNodes(this.root, "rra");
    }

    @Override
    String getVersion() {
        return Util.Xml.getChildValue(this.root, "version");
    }

    @Override
    long getLastUpdateTime() {
        return Util.Xml.getChildValueAsLong(this.root, "lastupdate");
    }

    @Override
    long getStep() {
        return Util.Xml.getChildValueAsLong(this.root, "step");
    }

    @Override
    int getDsCount() {
        return this.dsNodes.length;
    }

    @Override
    int getArcCount() {
        return this.arcNodes.length;
    }

    @Override
    String getDsName(int n) {
        return Util.Xml.getChildValue(this.dsNodes[n], "name");
    }

    @Override
    String getDsType(int n) {
        return Util.Xml.getChildValue(this.dsNodes[n], "type");
    }

    @Override
    long getHeartbeat(int n) {
        return Util.Xml.getChildValueAsLong(this.dsNodes[n], "minimal_heartbeat");
    }

    @Override
    double getMinValue(int n) {
        return Util.Xml.getChildValueAsDouble(this.dsNodes[n], "min");
    }

    @Override
    double getMaxValue(int n) {
        return Util.Xml.getChildValueAsDouble(this.dsNodes[n], "max");
    }

    @Override
    double getLastValue(int n) {
        return Util.Xml.getChildValueAsDouble(this.dsNodes[n], "last_ds");
    }

    @Override
    double getAccumValue(int n) {
        return Util.Xml.getChildValueAsDouble(this.dsNodes[n], "value");
    }

    @Override
    long getNanSeconds(int n) {
        return Util.Xml.getChildValueAsLong(this.dsNodes[n], "unknown_sec");
    }

    @Override
    ConsolFun getConsolFun(int n) {
        return ConsolFun.valueOf(Util.Xml.getChildValue(this.arcNodes[n], "cf"));
    }

    @Override
    double getXff(int n) {
        Node node = this.arcNodes[n];
        Node[] nodeArray = Util.Xml.getChildNodes(node, "params");
        if (nodeArray.length == 0) {
            return Util.Xml.getChildValueAsDouble(node, "xff");
        }
        return Util.Xml.getChildValueAsDouble(nodeArray[0], "xff");
    }

    @Override
    int getSteps(int n) {
        return Util.Xml.getChildValueAsInt(this.arcNodes[n], "pdp_per_row");
    }

    @Override
    double getStateAccumValue(int n, int n2) {
        Node node = Util.Xml.getFirstChildNode(this.arcNodes[n], "cdp_prep");
        Node[] nodeArray = Util.Xml.getChildNodes(node, "ds");
        return Util.Xml.getChildValueAsDouble(nodeArray[n2], "value");
    }

    @Override
    int getStateNanSteps(int n, int n2) {
        Node node = Util.Xml.getFirstChildNode(this.arcNodes[n], "cdp_prep");
        Node[] nodeArray = Util.Xml.getChildNodes(node, "ds");
        return Util.Xml.getChildValueAsInt(nodeArray[n2], "unknown_datapoints");
    }

    @Override
    int getRows(int n) {
        Node node = Util.Xml.getFirstChildNode(this.arcNodes[n], "database");
        Node[] nodeArray = Util.Xml.getChildNodes(node, "row");
        return nodeArray.length;
    }

    @Override
    double[] getValues(int n, int n2) {
        Node node = Util.Xml.getFirstChildNode(this.arcNodes[n], "database");
        Node[] nodeArray = Util.Xml.getChildNodes(node, "row");
        double[] dArray = new double[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            Node[] nodeArray2 = Util.Xml.getChildNodes(nodeArray[i], "v");
            Node node2 = nodeArray2[n2];
            dArray[i] = Util.parseDouble(node2.getFirstChild().getNodeValue().trim());
        }
        return dArray;
    }
}

