/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rrd4j.core.Util;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class XmlTemplate {
    private static final String PATTERN_STRING = "\\$\\{(\\w+)\\}";
    private static final Pattern PATTERN = Pattern.compile("\\$\\{(\\w+)\\}");
    protected Element root;
    private HashMap<String, Object> valueMap = new HashMap();
    private HashSet<Node> validatedNodes = new HashSet();

    protected XmlTemplate(InputSource inputSource) throws IOException {
        this.root = Util.Xml.getRootElement(inputSource);
    }

    protected XmlTemplate(String string) throws IOException {
        this.root = Util.Xml.getRootElement(string);
    }

    protected XmlTemplate(File file) throws IOException {
        this.root = Util.Xml.getRootElement(file);
    }

    public void clearValues() {
        this.valueMap.clear();
    }

    public void setVariable(String string, String string2) {
        this.valueMap.put(string, string2);
    }

    public void setVariable(String string, int n) {
        this.valueMap.put(string, new Integer(n));
    }

    public void setVariable(String string, long l) {
        this.valueMap.put(string, new Long(l));
    }

    public void setVariable(String string, double d) {
        this.valueMap.put(string, new Double(d));
    }

    public void setVariable(String string, Color color) {
        String string2 = this.byteToHex(color.getRed());
        String string3 = this.byteToHex(color.getGreen());
        String string4 = this.byteToHex(color.getBlue());
        String string5 = this.byteToHex(color.getAlpha());
        this.valueMap.put(string, "#" + string2 + string3 + string4 + string5);
    }

    private String byteToHex(int n) {
        String string = Integer.toHexString(n);
        while (string.length() < 2) {
            string = "0" + string;
        }
        return string;
    }

    public void setVariable(String string, Date date) {
        this.setVariable(string, Util.getTimestamp(date));
    }

    public void setVariable(String string, Calendar calendar) {
        this.setVariable(string, Util.getTimestamp(calendar));
    }

    public void setVariable(String string, boolean bl) {
        this.valueMap.put(string, "" + bl);
    }

    public boolean hasVariables() {
        return PATTERN.matcher(this.root.toString()).find();
    }

    public String[] getVariables() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = PATTERN.matcher(this.root.toString());
        while (matcher.find()) {
            String string = matcher.group(1);
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected static Node[] getChildNodes(Node node, String string) {
        return Util.Xml.getChildNodes(node, string);
    }

    protected static Node[] getChildNodes(Node node) {
        return Util.Xml.getChildNodes(node, null);
    }

    protected static Node getFirstChildNode(Node node, String string) {
        return Util.Xml.getFirstChildNode(node, string);
    }

    protected boolean hasChildNode(Node node, String string) {
        return Util.Xml.hasChildNode(node, string);
    }

    protected String getChildValue(Node node, String string) {
        return this.getChildValue(node, string, true);
    }

    protected String getChildValue(Node node, String string, boolean bl) {
        String string2 = Util.Xml.getChildValue(node, string, bl);
        return this.resolveMappings(string2);
    }

    protected String getValue(Node node) {
        return this.getValue(node, true);
    }

    protected String getValue(Node node, boolean bl) {
        String string = Util.Xml.getValue(node, bl);
        return this.resolveMappings(string);
    }

    private String resolveMappings(String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = PATTERN.matcher(string);
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (matcher.find()) {
            String string2 = matcher.group(1);
            if (this.valueMap.containsKey(string2)) {
                stringBuilder.append(string.substring(n, matcher.start()));
                stringBuilder.append(this.valueMap.get(string2).toString());
                n = matcher.end();
                continue;
            }
            throw new IllegalArgumentException("No mapping found for template variable ${" + string2 + "}");
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    protected int getChildValueAsInt(Node node, String string) {
        String string2 = this.getChildValue(node, string);
        return Integer.parseInt(string2);
    }

    protected int getValueAsInt(Node node) {
        String string = this.getValue(node);
        return Integer.parseInt(string);
    }

    protected long getChildValueAsLong(Node node, String string) {
        String string2 = this.getChildValue(node, string);
        return Long.parseLong(string2);
    }

    protected long getValueAsLong(Node node) {
        String string = this.getValue(node);
        return Long.parseLong(string);
    }

    protected double getChildValueAsDouble(Node node, String string) {
        String string2 = this.getChildValue(node, string);
        return Util.parseDouble(string2);
    }

    protected double getValueAsDouble(Node node) {
        String string = this.getValue(node);
        return Util.parseDouble(string);
    }

    protected boolean getChildValueAsBoolean(Node node, String string) {
        String string2 = this.getChildValue(node, string);
        return Util.parseBoolean(string2);
    }

    protected boolean getValueAsBoolean(Node node) {
        String string = this.getValue(node);
        return Util.parseBoolean(string);
    }

    protected Paint getValueAsColor(Node node) {
        String string = this.getValue(node);
        return Util.parseColor(string);
    }

    protected boolean isEmptyNode(Node node) {
        return node.getNodeName().equals("#comment") || node.getNodeName().equals("#text") && node.getNodeValue().trim().length() == 0;
    }

    protected void validateTagsOnlyOnce(Node node, String[] stringArray) {
        Node[] nodeArray;
        if (this.validatedNodes.contains(node)) {
            return;
        }
        block0: for (Node node2 : nodeArray = XmlTemplate.getChildNodes(node)) {
            String string = node2.getNodeName();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(string)) {
                    stringArray[i] = "<--removed-->";
                    continue block0;
                }
                if (stringArray[i].equals(string + "*")) continue block0;
            }
            if (this.isEmptyNode(node2)) continue;
            throw new IllegalArgumentException("Unexpected tag encountered: <" + string + ">");
        }
        this.validatedNodes.add(node);
    }
}

