/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.data;

import java.util.Arrays;
import org.rrd4j.core.Util;

class Normalizer {
    private final long[] timestamps;
    final int count;
    final long step;

    Normalizer(long[] lArray) {
        this.timestamps = lArray;
        this.step = lArray[1] - lArray[0];
        this.count = lArray.length;
    }

    double[] normalize(long[] lArray, double[] dArray) {
        int n;
        int n2 = lArray.length;
        long l = lArray[1] - lArray[0];
        if (n2 == this.count && l == this.step && lArray[0] == this.timestamps[0]) {
            return Normalizer.getCopyOf(dArray);
        }
        double[] dArray2 = new double[this.count];
        Arrays.fill(dArray2, Double.NaN);
        int n3 = 0;
        for (n = 0; n < n2 && n3 < this.count; ++n) {
            double d = dArray[n];
            if (Double.isNaN(d)) continue;
            long l2 = lArray[n] - l;
            while (n3 < this.count && l2 >= this.timestamps[n3]) {
                ++n3;
            }
            boolean bl = true;
            for (int i = n3; bl && i < this.count; ++i) {
                long l3;
                long l4 = this.timestamps[i] - this.step;
                long l5 = Math.max(l2, l4);
                if (l5 < (l3 = Math.min(lArray[n], this.timestamps[i]))) {
                    dArray2[i] = Util.sum(dArray2[i], (double)(l3 - l5) * dArray[n]);
                    continue;
                }
                bl = false;
            }
        }
        n = 0;
        while (n < this.count) {
            int n4 = n++;
            dArray2[n4] = dArray2[n4] / (double)this.step;
        }
        return dArray2;
    }

    private static double[] getCopyOf(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        return dArray2;
    }
}

