/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.ArcDef;
import org.rrd4j.core.DsDef;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdToolkit;
import org.rrd4j.inspector.EditArchiveDialog;
import org.rrd4j.inspector.EditDatasourceDialog;
import org.rrd4j.inspector.GraphFrame;
import org.rrd4j.inspector.InspectorModel;
import org.rrd4j.inspector.RrdNode;
import org.rrd4j.inspector.Util;

public class RrdInspector
extends JFrame {
    static final boolean SHOULD_CREATE_BACKUPS = true;
    static final String TITLE = "RRD File Inspector";
    static final boolean SHOULD_FIX_ARCHIVED_VALUES = false;
    static final Dimension MAIN_TREE_SIZE = new Dimension(250, 400);
    static final Dimension INFO_PANE_SIZE = new Dimension(450, 400);
    static final String ABOUT = "RRD4J\nRRD File Inspector\nCopyright 2010 Sasa Markovic and Mathias Bogaert. Licensed under the Apache License, Version 2.0.";
    JTabbedPane tabbedPane = new JTabbedPane();
    private JTree mainTree = new JTree();
    private JSplitPane splitPane = new JSplitPane();
    private JTable generalTable = new JTable();
    private JTable datasourceTable = new JTable();
    private JTable archiveTable = new JTable();
    private JTable dataTable = new JTable();
    private InspectorModel inspectorModel = new InspectorModel();
    private String lastDirectory = null;

    private RrdInspector(String string) throws Exception {
        super(TITLE);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                RrdInspector.this.constructUI();
                RrdInspector.this.pack();
            }
        });
        Util.placeWindow(this);
        this.setVisible(true);
        if (string == null) {
            this.selectFile();
        } else {
            this.loadFile(new File(string));
        }
    }

    private void constructUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        this.getContentPane().add((Component)jToolBar, "North");
        jToolBar.setFloatable(true);
        JButton jButton = new JButton(RrdInspector.loadIcon("open-24.png"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.selectFile();
            }
        });
        jToolBar.add(jButton);
        final JButton jButton2 = new JButton(RrdInspector.loadIcon("graph-24.gif"));
        jButton2.setEnabled(false);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.plotArchive();
            }
        });
        jToolBar.add(jButton2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.mainTree);
        jScrollPane.putClientProperty("JScrollBar.fastWheelScrolling", Boolean.TRUE);
        jPanel2.add(jScrollPane);
        jPanel2.setPreferredSize(MAIN_TREE_SIZE);
        this.splitPane.setLeftComponent(jPanel2);
        this.splitPane.setOneTouchExpandable(true);
        this.mainTree.getSelectionModel().setSelectionMode(1);
        this.mainTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                RrdInspector.this.nodeChangedAction();
                jButton2.setEnabled(RrdInspector.this.isArchiveNode(RrdInspector.this.getSelectedRrdNode()));
            }
        });
        this.mainTree.setModel(this.inspectorModel.getMainTreeModel());
        JScrollPane jScrollPane2 = new JScrollPane(this.generalTable);
        jScrollPane2.putClientProperty("JScrollBar.fastWheelScrolling", Boolean.TRUE);
        jScrollPane2.setPreferredSize(INFO_PANE_SIZE);
        this.tabbedPane.add("General info", jScrollPane2);
        this.generalTable.setModel(this.inspectorModel.getGeneralTableModel());
        this.generalTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.generalTable.getColumnModel().getColumn(0).setMaxWidth(150);
        JScrollPane jScrollPane3 = new JScrollPane(this.datasourceTable);
        jScrollPane3.putClientProperty("JScrollBar.fastWheelScrolling", Boolean.TRUE);
        jScrollPane3.setPreferredSize(INFO_PANE_SIZE);
        this.tabbedPane.add("Datasource info", jScrollPane3);
        this.datasourceTable.setModel(this.inspectorModel.getDatasourceTableModel());
        this.datasourceTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.datasourceTable.getColumnModel().getColumn(0).setMaxWidth(150);
        JScrollPane jScrollPane4 = new JScrollPane(this.archiveTable);
        jScrollPane4.putClientProperty("JScrollBar.fastWheelScrolling", Boolean.TRUE);
        this.archiveTable.setModel(this.inspectorModel.getArchiveTableModel());
        this.archiveTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.archiveTable.getColumnModel().getColumn(0).setMaxWidth(150);
        jScrollPane4.setPreferredSize(INFO_PANE_SIZE);
        this.tabbedPane.add("Archive info", jScrollPane4);
        JScrollPane jScrollPane5 = new JScrollPane(this.dataTable);
        jScrollPane5.putClientProperty("JScrollBar.fastWheelScrolling", Boolean.TRUE);
        this.dataTable.setModel(this.inspectorModel.getDataTableModel());
        this.dataTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.dataTable.getColumnModel().getColumn(0).setMaxWidth(100);
        this.dataTable.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.dataTable.getColumnModel().getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){
            {
                this.setBackground(Color.YELLOW);
            }
        });
        jScrollPane5.setPreferredSize(INFO_PANE_SIZE);
        this.tabbedPane.add("Archive data", jScrollPane5);
        this.splitPane.setRightComponent(this.tabbedPane);
        jPanel.add((Component)this.splitPane, "Center");
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("Open RRD file...", 79);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.selectFile();
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Open RRD file in new window...");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    new RrdInspector(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("Add datasource...");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.addDatasource();
            }
        });
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Edit datasource...");
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.editDatasource();
            }
        });
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Remove datasource");
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.removeDatasource();
            }
        });
        jMenu.add(jMenuItem5);
        jMenu.addSeparator();
        JMenuItem jMenuItem6 = new JMenuItem("Add archive...");
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.addArchive();
            }
        });
        jMenu.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem("Edit archive...");
        jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.editArchive();
            }
        });
        jMenu.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem("Remove archive");
        jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.removeArchive();
            }
        });
        jMenu.add(jMenuItem8);
        JMenuItem jMenuItem9 = new JMenuItem("Plot archive values...");
        jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.plotArchive();
            }
        });
        jMenu.add(jMenuItem9);
        jMenu.addSeparator();
        JMenuItem jMenuItem10 = new JMenuItem("Exit", 88);
        jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(jMenuItem10);
        JMenu jMenu2 = new JMenu("Help");
        jMenu.setMnemonic(72);
        JMenuItem jMenuItem11 = new JMenuItem("About...", 65);
        jMenuItem11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.about();
            }
        });
        jMenu2.add(jMenuItem11);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                RrdInspector.this.closeWindow();
            }
        });
    }

    private void closeWindow() {
        Util.dismissWindow(this);
    }

    private void about() {
        JOptionPane.showMessageDialog(this, ABOUT, "About", 1);
    }

    public static Icon loadIcon(String string) {
        return new ImageIcon(RrdInspector.class.getResource("/" + string));
    }

    private void nodeChangedAction() {
        RrdNode rrdNode = this.getSelectedRrdNode();
        if (rrdNode != null) {
            this.inspectorModel.selectModel(rrdNode.getDsIndex(), rrdNode.getArcIndex());
            if (rrdNode.getDsIndex() >= 0 && rrdNode.getArcIndex() >= 0) {
                if (this.tabbedPane.getSelectedIndex() < 2) {
                    this.tabbedPane.setSelectedIndex(2);
                }
            } else if (rrdNode.getDsIndex() >= 0) {
                this.tabbedPane.setSelectedIndex(1);
            } else {
                this.tabbedPane.setSelectedIndex(0);
            }
        }
    }

    private RrdNode getSelectedRrdNode() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object;
        TreePath treePath = this.mainTree.getSelectionPath();
        if (treePath != null && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof RrdNode) {
            return (RrdNode)object;
        }
        return null;
    }

    private void selectFile() {
        File file;
        JFileChooser jFileChooser = new JFileChooser(this.lastDirectory);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String string = file.getAbsolutePath().toLowerCase();
                return file.isDirectory() || string.endsWith(".rrd") || string.endsWith(".jrb") || string.endsWith(".rrd4j");
            }

            @Override
            public String getDescription() {
                return "Rrd4j RRD files (*.rrd;*.jrb;*.rrd4j)";
            }
        };
        jFileChooser.setFileFilter(fileFilter);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.lastDirectory = file.getParent();
            this.loadFile(file);
        }
    }

    private void loadFile(File file) {
        this.inspectorModel.setFile(file);
        this.tabbedPane.setSelectedIndex(0);
    }

    private void addDatasource() {
        if (!this.inspectorModel.isOk()) {
            Util.error((Component)this, "Open a valid RRD file first.");
            return;
        }
        DsDef dsDef = new EditDatasourceDialog((Frame)this, null).getDsDef();
        if (dsDef != null) {
            try {
                String string = this.inspectorModel.getFile().getCanonicalPath();
                RrdToolkit.addDatasource(string, dsDef, true);
                this.inspectorModel.refresh();
                this.tabbedPane.setSelectedIndex(0);
            }
            catch (Exception exception) {
                Util.error((Component)this, exception);
            }
        }
    }

    private void addArchive() {
        if (!this.inspectorModel.isOk()) {
            Util.error((Component)this, "Open a valid RRD file first.");
            return;
        }
        ArcDef arcDef = new EditArchiveDialog((Frame)this, null).getArcDef();
        if (arcDef != null) {
            try {
                String string = this.inspectorModel.getFile().getCanonicalPath();
                RrdToolkit.addArchive(string, arcDef, true);
                this.inspectorModel.refresh();
                this.tabbedPane.setSelectedIndex(0);
            }
            catch (Exception exception) {
                Util.error((Component)this, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editDatasource() {
        if (!this.inspectorModel.isOk()) {
            Util.error((Component)this, "Open a valid RRD file first.");
            return;
        }
        RrdNode rrdNode = this.getSelectedRrdNode();
        int n = -1;
        if (rrdNode == null || (n = rrdNode.getDsIndex()) < 0) {
            Util.error((Component)this, "Select datasource first");
            return;
        }
        try {
            String string = this.inspectorModel.getFile().getCanonicalPath();
            RrdDb rrdDb = new RrdDb(string, true);
            try {
                DsDef dsDef = rrdDb.getRrdDef().getDsDefs()[n];
                rrdDb.close();
                DsDef dsDef2 = new EditDatasourceDialog((Frame)this, dsDef).getDsDef();
                if (dsDef2 != null) {
                    RrdToolkit.setDsHeartbeat(string, dsDef2.getDsName(), dsDef2.getHeartbeat());
                    RrdToolkit.setDsMinMaxValue(string, dsDef2.getDsName(), dsDef2.getMinValue(), dsDef2.getMaxValue(), false);
                    this.inspectorModel.refresh();
                    this.tabbedPane.setSelectedIndex(0);
                }
            }
            finally {
                rrdDb.close();
            }
        }
        catch (Exception exception) {
            Util.error((Component)this, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editArchive() {
        if (!this.inspectorModel.isOk()) {
            Util.error((Component)this, "Open a valid RRD file first.");
            return;
        }
        RrdNode rrdNode = this.getSelectedRrdNode();
        int n = -1;
        if (rrdNode == null || (n = rrdNode.getArcIndex()) < 0) {
            Util.error((Component)this, "Select archive first");
            return;
        }
        try {
            String string = this.inspectorModel.getFile().getCanonicalPath();
            RrdDb rrdDb = new RrdDb(string, true);
            try {
                ArcDef arcDef = rrdDb.getRrdDef().getArcDefs()[n];
                rrdDb.close();
                ArcDef arcDef2 = new EditArchiveDialog((Frame)this, arcDef).getArcDef();
                if (arcDef2 != null) {
                    RrdToolkit.setArcXff(string, arcDef2.getConsolFun(), arcDef2.getSteps(), arcDef2.getXff());
                    RrdToolkit.resizeArchive(string, arcDef2.getConsolFun(), arcDef2.getSteps(), arcDef2.getRows(), true);
                    this.inspectorModel.refresh();
                    this.tabbedPane.setSelectedIndex(0);
                }
            }
            finally {
                rrdDb.close();
            }
        }
        catch (Exception exception) {
            Util.error((Component)this, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDatasource() {
        if (!this.inspectorModel.isOk()) {
            Util.error((Component)this, "Open a valid RRD file first.");
            return;
        }
        RrdNode rrdNode = this.getSelectedRrdNode();
        int n = -1;
        if (rrdNode == null || (n = rrdNode.getDsIndex()) < 0) {
            Util.error((Component)this, "Select datasource first");
            return;
        }
        try {
            String string;
            String string2 = this.inspectorModel.getFile().getCanonicalPath();
            RrdDb rrdDb = new RrdDb(string2, true);
            try {
                string = rrdDb.getRrdDef().getDsDefs()[n].getDsName();
            }
            finally {
                rrdDb.close();
            }
            RrdToolkit.removeDatasource(string2, string, true);
            this.inspectorModel.refresh();
            this.tabbedPane.setSelectedIndex(0);
        }
        catch (Exception exception) {
            Util.error((Component)this, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeArchive() {
        if (!this.inspectorModel.isOk()) {
            Util.error((Component)this, "Open a valid RRD file first.");
            return;
        }
        RrdNode rrdNode = this.getSelectedRrdNode();
        int n = -1;
        if (rrdNode == null || (n = rrdNode.getArcIndex()) < 0) {
            Util.error((Component)this, "Select archive first");
            return;
        }
        try {
            int n2;
            ConsolFun consolFun;
            String string = this.inspectorModel.getFile().getCanonicalPath();
            RrdDb rrdDb = new RrdDb(string, true);
            try {
                ArcDef arcDef = rrdDb.getRrdDef().getArcDefs()[n];
                consolFun = arcDef.getConsolFun();
                n2 = arcDef.getSteps();
            }
            finally {
                rrdDb.close();
            }
            RrdToolkit.removeArchive(string, consolFun, n2, true);
            this.inspectorModel.refresh();
            this.tabbedPane.setSelectedIndex(0);
        }
        catch (Exception exception) {
            Util.error((Component)this, exception);
        }
    }

    private void plotArchive() {
        if (!this.inspectorModel.isOk()) {
            Util.error((Component)this, "Open a valid RRD file first.");
            return;
        }
        RrdNode rrdNode = this.getSelectedRrdNode();
        if (!this.isArchiveNode(rrdNode)) {
            Util.error((Component)this, "Select archive first");
            return;
        }
        String string = this.inspectorModel.getFile().getAbsolutePath();
        new GraphFrame(string, rrdNode.getDsIndex(), rrdNode.getArcIndex());
    }

    private boolean isArchiveNode(RrdNode rrdNode) {
        return rrdNode != null && rrdNode.getArcIndex() >= 0;
    }

    private static void printUsageAndExit() {
        System.err.println("usage: " + RrdInspector.class.getName() + " [<filename>]");
        System.exit(1);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 1) {
            RrdInspector.printUsageAndExit();
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
                }
                catch (Exception exception) {
                    try {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
        });
        String string = stringArray.length == 1 ? stringArray[0] : null;
        new RrdInspector(string);
    }
}

