/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdBerkeleyDbBackend;

public class RrdBerkeleyDbBackendFactory
extends RrdBackendFactory {
    private final Database rrdDatabase;
    private final Set<String> pathCache = new CopyOnWriteArraySet<String>();

    public RrdBerkeleyDbBackendFactory(Database database) {
        this.rrdDatabase = database;
        RrdBackendFactory.registerAndSetAsDefaultFactory(this);
    }

    @Override
    protected RrdBackend open(String string, boolean bl) throws IOException {
        if (this.pathCache.contains(string)) {
            DatabaseEntry databaseEntry = new DatabaseEntry(string.getBytes("UTF-8"));
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            try {
                this.rrdDatabase.get(null, databaseEntry, databaseEntry2, LockMode.DEFAULT);
            }
            catch (DatabaseException databaseException) {
                throw new IOException("BerkeleyDB DatabaseException on " + string + "; " + databaseException.getMessage());
            }
            return new RrdBerkeleyDbBackend(databaseEntry2.getData(), string, this.rrdDatabase);
        }
        return new RrdBerkeleyDbBackend(string, this.rrdDatabase);
    }

    public void delete(String string) {
        try {
            this.rrdDatabase.delete(null, new DatabaseEntry(string.getBytes("UTF-8")));
        }
        catch (DatabaseException databaseException) {
            throw new RuntimeException(databaseException.getMessage(), databaseException);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(string + ": " + iOException.getMessage(), iOException);
        }
        this.pathCache.remove(string);
    }

    @Override
    protected boolean exists(String string) throws IOException {
        if (this.pathCache.contains(string)) {
            return true;
        }
        DatabaseEntry databaseEntry = new DatabaseEntry(string.getBytes("UTF-8"));
        databaseEntry.setPartial(0, 0, true);
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        try {
            boolean bl;
            boolean bl2 = bl = this.rrdDatabase.get(null, databaseEntry, databaseEntry2, LockMode.DEFAULT) == OperationStatus.SUCCESS;
            if (bl) {
                this.pathCache.add(string);
            }
            return bl;
        }
        catch (DatabaseException databaseException) {
            throw new IOException("BerkeleyDB DatabaseException on " + string + "; " + databaseException.getMessage());
        }
    }

    @Override
    protected boolean shouldValidateHeader(String string) {
        return false;
    }

    @Override
    public String getName() {
        return "BERKELEY";
    }
}

