/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.rrd4j.core.RrdRandomAccessFileBackend;
import sun.nio.ch.DirectBuffer;

public class RrdNioBackend
extends RrdRandomAccessFileBackend {
    private MappedByteBuffer byteBuffer;
    private final Runnable syncRunnable = new Runnable(){

        @Override
        public void run() {
            RrdNioBackend.this.sync();
        }
    };
    private ScheduledFuture<?> syncRunnableHandle = null;

    protected RrdNioBackend(String string, boolean bl, ScheduledExecutorService scheduledExecutorService, int n) throws IOException {
        super(string, bl);
        try {
            this.mapFile();
        }
        catch (IOException iOException) {
            super.close();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            super.close();
            throw runtimeException;
        }
        try {
            if (!bl) {
                this.syncRunnableHandle = scheduledExecutorService.scheduleWithFixedDelay(this.syncRunnable, n, n, TimeUnit.SECONDS);
            }
        }
        catch (RuntimeException runtimeException) {
            this.unmapFile();
            super.close();
            throw runtimeException;
        }
    }

    private void mapFile() throws IOException {
        long l = this.getLength();
        if (l > 0L) {
            FileChannel.MapMode mapMode = this.readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            this.byteBuffer = this.rafile.getChannel().map(mapMode, 0L, l);
        }
    }

    private void unmapFile() {
        if (this.byteBuffer != null) {
            if (this.byteBuffer instanceof DirectBuffer) {
                ((DirectBuffer)((Object)this.byteBuffer)).cleaner().clean();
            }
            this.byteBuffer = null;
        }
    }

    @Override
    protected synchronized void setLength(long l) throws IOException {
        this.unmapFile();
        super.setLength(l);
        this.mapFile();
    }

    @Override
    protected synchronized void write(long l, byte[] byArray) throws IOException {
        if (this.byteBuffer == null) {
            throw new IOException("Write failed, file " + this.getPath() + " not mapped for I/O");
        }
        this.byteBuffer.position((int)l);
        this.byteBuffer.put(byArray);
    }

    @Override
    protected synchronized void read(long l, byte[] byArray) throws IOException {
        if (this.byteBuffer == null) {
            throw new IOException("Read failed, file " + this.getPath() + " not mapped for I/O");
        }
        this.byteBuffer.position((int)l);
        this.byteBuffer.get(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        try {
            if (!this.readOnly) {
                this.syncRunnableHandle.cancel(false);
                this.sync();
            }
            this.unmapFile();
        }
        finally {
            super.close();
        }
    }

    protected synchronized void sync() {
        if (this.byteBuffer != null) {
            this.byteBuffer.force();
        }
    }
}

