/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.rrd4j.core.RrdFileBackend;

public class RrdRandomAccessFileBackend
extends RrdFileBackend {
    protected final RandomAccessFile rafile;

    protected RrdRandomAccessFileBackend(String string, boolean bl) throws IOException {
        super(string, bl);
        this.rafile = new RandomAccessFile(string, bl ? "r" : "rw");
    }

    @Override
    public void close() throws IOException {
        this.rafile.getFD().sync();
        this.rafile.close();
    }

    @Override
    protected void write(long l, byte[] byArray) throws IOException {
        this.rafile.seek(l);
        this.rafile.write(byArray);
    }

    @Override
    protected void read(long l, byte[] byArray) throws IOException {
        this.rafile.seek(l);
        if (this.rafile.read(byArray) != byArray.length) {
            throw new IOException("Not enough bytes available in file " + this.getPath());
        }
    }

    @Override
    protected void setLength(long l) throws IOException {
        this.rafile.setLength(l);
    }
}

