/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.rrd4j.core.jrrd.CDPStatusBlock;
import org.rrd4j.core.jrrd.ConsolidationFunctionType;
import org.rrd4j.core.jrrd.DataChunk;
import org.rrd4j.core.jrrd.RRDFile;
import org.rrd4j.core.jrrd.RRDatabase;
import org.rrd4j.core.jrrd.UnivalArray;

public class Archive {
    final RRDatabase db;
    final long offset;
    long dataOffset;
    long size;
    final ConsolidationFunctionType type;
    final int rowCount;
    final int pdpCount;
    final double xff;
    List<CDPStatusBlock> cdpStatusBlocks;
    int currentRow;
    private double[][] values;

    Archive(RRDatabase rRDatabase) throws IOException {
        this.db = rRDatabase;
        RRDFile rRDFile = rRDatabase.rrdFile;
        this.offset = rRDFile.getFilePointer();
        this.type = ConsolidationFunctionType.valueOf(rRDFile.readString(20).toUpperCase());
        if (rRDFile.getBits() == 32) {
            this.rowCount = rRDFile.readInt();
            this.pdpCount = rRDFile.readInt();
            rRDFile.align();
        } else {
            rRDFile.align();
            this.rowCount = rRDFile.readLong();
            this.pdpCount = rRDFile.readLong();
        }
        UnivalArray univalArray = rRDFile.getUnivalArray(10);
        this.xff = univalArray.getDouble(rra_par_en.RRA_cdp_xff_val);
        this.size = rRDFile.getFilePointer() - this.offset;
    }

    public ConsolidationFunctionType getType() {
        return this.type;
    }

    void loadCDPStatusBlocks(RRDFile rRDFile, int n) throws IOException {
        this.cdpStatusBlocks = new ArrayList<CDPStatusBlock>();
        for (int i = 0; i < n; ++i) {
            this.cdpStatusBlocks.add(new CDPStatusBlock(rRDFile));
        }
    }

    public CDPStatusBlock getCDPStatusBlock(int n) {
        return this.cdpStatusBlocks.get(n);
    }

    public Iterator<CDPStatusBlock> getCDPStatusBlocks() {
        return this.cdpStatusBlocks.iterator();
    }

    void loadCurrentRow(RRDFile rRDFile) throws IOException {
        this.currentRow = rRDFile.readLong();
    }

    void loadData(RRDFile rRDFile, int n) throws IOException {
        this.dataOffset = rRDFile.getFilePointer();
        rRDFile.skipBytes(8 * this.rowCount * n);
    }

    void loadData(DataChunk dataChunk) throws IOException {
        long l = dataChunk.start < 0 ? (long)(this.currentRow + 1) : (long)(this.currentRow + dataChunk.start + 1);
        this.db.rrdFile.ras.seek(this.dataOffset + (long)dataChunk.dsCount * l * 8L);
        double[][] dArray = dataChunk.data;
        int n = 0;
        int n2 = dataChunk.start;
        while (n2 < this.rowCount - dataChunk.end) {
            int n3;
            if (n2 < 0) {
                for (n3 = 0; n3 < dataChunk.dsCount; ++n3) {
                    dArray[n][n3] = Double.NaN;
                }
            } else if (n2 >= this.rowCount) {
                for (n3 = 0; n3 < dataChunk.dsCount; ++n3) {
                    dArray[n][n3] = Double.NaN;
                }
            } else {
                if (l >= (long)this.rowCount) {
                    this.db.rrdFile.ras.seek(this.dataOffset + (long)dataChunk.dsCount * (l -= (long)this.rowCount) * 8L);
                }
                for (n3 = 0; n3 < dataChunk.dsCount; ++n3) {
                    dArray[n][n3] = this.db.rrdFile.readDouble();
                }
                ++l;
            }
            ++n2;
            ++n;
        }
    }

    void printInfo(PrintStream printStream, NumberFormat numberFormat, int n) {
        StringBuilder stringBuilder = new StringBuilder("rra[");
        stringBuilder.append(n);
        printStream.print(stringBuilder);
        printStream.print("].cf = \"");
        printStream.print((Object)this.type);
        printStream.println("\"");
        printStream.print(stringBuilder);
        printStream.print("].rows = ");
        printStream.println(this.rowCount);
        printStream.print(stringBuilder);
        printStream.print("].pdp_per_row = ");
        printStream.println(this.pdpCount);
        printStream.print(stringBuilder);
        printStream.print("].xff = ");
        printStream.println(this.xff);
        stringBuilder.append("].cdp_prep[");
        int n2 = 0;
        for (CDPStatusBlock cDPStatusBlock : this.cdpStatusBlocks) {
            printStream.print(stringBuilder);
            printStream.print(n2);
            printStream.print("].value = ");
            double d = cDPStatusBlock.value;
            printStream.println(Double.isNaN(d) ? "NaN" : numberFormat.format(d));
            printStream.print(stringBuilder);
            printStream.print(n2++);
            printStream.print("].unknown_datapoints = ");
            printStream.println(cDPStatusBlock.unknownDatapoints);
        }
    }

    void toXml(PrintStream printStream) {
        try {
            printStream.println("\t<rra>");
            printStream.print("\t\t<cf> ");
            printStream.print((Object)this.type);
            printStream.println(" </cf>");
            printStream.print("\t\t<pdp_per_row> ");
            printStream.print(this.pdpCount);
            printStream.print(" </pdp_per_row> <!-- ");
            printStream.print(this.db.header.pdpStep * this.pdpCount);
            printStream.println(" seconds -->");
            printStream.print("\t\t<xff> ");
            printStream.print(this.xff);
            printStream.println(" </xff>");
            printStream.println();
            printStream.println("\t\t<cdp_prep>");
            for (int i = 0; i < this.cdpStatusBlocks.size(); ++i) {
                this.cdpStatusBlocks.get(i).toXml(printStream);
            }
            printStream.println("\t\t</cdp_prep>");
            printStream.println("\t\t<database>");
            long l = -(this.rowCount - 1);
            int n = 0;
            int n2 = this.currentRow;
            this.db.rrdFile.ras.seek(this.dataOffset + (long)((n2 + 1) * 16));
            long l2 = this.db.lastUpdate.getTime() / 1000L;
            int n3 = this.db.header.pdpStep;
            DecimalFormat decimalFormat = new DecimalFormat("0.0000000000E0");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
            while (n++ < this.rowCount) {
                if (++n2 == this.rowCount) {
                    n2 = 0;
                    this.db.rrdFile.ras.seek(this.dataOffset);
                }
                long l3 = l2 - l2 % (long)(this.pdpCount * n3) + l * (long)this.pdpCount * (long)n3;
                ++l;
                printStream.print("\t\t\t<!-- ");
                printStream.print(simpleDateFormat.format(new Date(l3 * 1000L)));
                printStream.print(" / ");
                printStream.print(l3);
                printStream.print(" --> ");
                for (int i = 0; i < this.db.header.dsCount; ++i) {
                    printStream.print("<v> ");
                    double d = this.db.rrdFile.readDouble();
                    if (Double.isNaN(d)) {
                        printStream.print("NaN");
                    } else {
                        printStream.print(decimalFormat.format(d));
                    }
                    printStream.print(" </v>");
                }
                printStream.println("</row>");
            }
            printStream.println("\t\t</database>");
            printStream.println("\t</rra>");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public double[][] getValues() throws IOException {
        if (this.values != null) {
            return this.values;
        }
        this.values = new double[this.db.header.dsCount][this.rowCount];
        int n = this.currentRow;
        this.db.rrdFile.ras.seek(this.dataOffset + (long)((n + 1) * this.db.header.dsCount * 8));
        for (int i = 0; i < this.rowCount; ++i) {
            if (++n == this.rowCount) {
                n = 0;
                this.db.rrdFile.ras.seek(this.dataOffset);
            }
            for (int j = 0; j < this.db.header.dsCount; ++j) {
                double d;
                this.values[j][i] = d = this.db.rrdFile.readDouble();
            }
        }
        return this.values;
    }

    public int getPdpCount() {
        return this.pdpCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public double getXff() {
        return this.xff;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[Archive: OFFSET=0x");
        stringBuilder.append(Long.toHexString(this.offset));
        stringBuilder.append(", SIZE=0x");
        stringBuilder.append(Long.toHexString(this.size));
        stringBuilder.append(", type=");
        stringBuilder.append((Object)this.type);
        stringBuilder.append(", rowCount=");
        stringBuilder.append(this.rowCount);
        stringBuilder.append(", pdpCount=");
        stringBuilder.append(this.pdpCount);
        stringBuilder.append(", xff=");
        stringBuilder.append(this.xff);
        stringBuilder.append(", currentRow=");
        stringBuilder.append(this.currentRow);
        stringBuilder.append("]");
        for (CDPStatusBlock cDPStatusBlock : this.cdpStatusBlocks) {
            stringBuilder.append("\n\t\t");
            stringBuilder.append(cDPStatusBlock.toString());
        }
        return stringBuilder.toString();
    }

    private static enum rra_par_en {
        RRA_cdp_xff_val,
        RRA_hw_alpha;

    }
}

