/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.data;

import java.util.ArrayList;
import java.util.Arrays;
import org.rrd4j.core.Util;
import org.rrd4j.data.Aggregates;

class Aggregator {
    private final long[] timestamps;
    private final long step;
    private final double[] values;

    Aggregator(long[] lArray, double[] dArray) {
        assert (lArray.length == dArray.length) : "Incompatible timestamps/values arrays (unequal lengths)";
        assert (lArray.length >= 2) : "At least two timestamps must be supplied";
        this.timestamps = lArray;
        this.values = dArray;
        this.step = lArray[1] - lArray[0];
    }

    Aggregates getAggregates(long l, long l2) {
        Aggregates aggregates = new Aggregates();
        long l3 = 0L;
        boolean bl = false;
        double d = 0.0;
        for (int i = 0; i < this.timestamps.length; ++i) {
            long l4 = Math.max(this.timestamps[i] - this.step, l);
            long l5 = Math.min(this.timestamps[i], l2);
            long l6 = l5 - l4;
            if (l6 <= 0L) continue;
            double d2 = this.values[i];
            aggregates.min = Util.min(aggregates.min, d2);
            aggregates.max = Util.max(aggregates.max, d2);
            aggregates.total = Util.sum(aggregates.total, d2);
            if (!bl) {
                aggregates.first = d2;
                bl = true;
                aggregates.last = d2;
            } else if (l6 >= this.step) {
                aggregates.last = d2;
            }
            if (Double.isNaN(d2)) continue;
            d = Util.sum(d, (double)l6 * d2);
            l3 += l6;
        }
        aggregates.average = l3 > 0L ? d / (double)l3 : Double.NaN;
        return aggregates;
    }

    double getPercentile(long l, long l2, double d) {
        int n;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (n = 0; n < this.timestamps.length; ++n) {
            long l3 = Math.max(this.timestamps[n] - this.step, l);
            long l4 = Math.min(this.timestamps[n], l2);
            if (l4 <= l3 || Double.isNaN(this.values[n])) continue;
            arrayList.add(new Double(this.values[n]));
        }
        n = arrayList.size();
        if (n > 1) {
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = (Double)arrayList.get(i);
            }
            Arrays.sort(dArray);
            double d2 = (100.0 - d) / 100.0;
            n -= (int)Math.ceil((double)n * d2);
            if (n > 0) {
                return dArray[n - 1];
            }
        }
        return Double.NaN;
    }
}

