/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import org.rrd4j.graph.ImageParameters;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;

class Mapper {
    private RrdGraphDef gdef;
    private ImageParameters im;
    private double pixieX;
    private double pixieY;

    Mapper(RrdGraph rrdGraph) {
        this.gdef = rrdGraph.gdef;
        this.im = rrdGraph.im;
        this.pixieX = (double)this.im.xsize / (double)(this.im.end - this.im.start);
        this.pixieY = !this.gdef.logarithmic ? (double)this.im.ysize / (this.im.maxval - this.im.minval) : (double)this.im.ysize / (Math.log10(this.im.maxval) - Math.log10(this.im.minval));
    }

    int xtr(double d) {
        return (int)((double)this.im.xorigin + this.pixieX * (d - (double)this.im.start));
    }

    int ytr(double d) {
        double d2 = !this.gdef.logarithmic ? (double)this.im.yorigin - this.pixieY * (d - this.im.minval) + 0.5 : (d < this.im.minval ? (double)this.im.yorigin : (double)this.im.yorigin - this.pixieY * (Math.log10(d) - Math.log10(this.im.minval)) + 0.5);
        if (!this.gdef.rigid) {
            return (int)d2;
        }
        if ((int)d2 > this.im.yorigin) {
            return this.im.yorigin + 2;
        }
        if ((int)d2 < this.im.yorigin - this.im.ysize) {
            return this.im.yorigin - this.im.ysize - 2;
        }
        return (int)d2;
    }
}

