/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.rrd4j.core.ArcDef;
import org.rrd4j.core.Archive;
import org.rrd4j.core.Datasource;
import org.rrd4j.core.DsDef;
import org.rrd4j.core.Robin;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.data.LinearInterpolator;
import org.rrd4j.data.Plottable;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;
import org.rrd4j.graph.RrdGraphInfo;
import org.rrd4j.inspector.Util;

class GraphFrame
extends JFrame {
    private static final Color COLOR = Color.RED;
    private static final int WIDTH = 400;
    private static final int HEIGHT = 240;
    private int deltaWidth = 0;
    private int deltaHeight = 0;
    private Color color = COLOR;
    private GraphPanel graphPanel = new GraphPanel();
    private JComboBox graphCombo = new JComboBox();
    private RrdGraph rrdGraph;
    private String sourcePath;
    private int dsIndex;
    private int arcIndex;

    GraphFrame(String string, int n, int n2) {
        this.sourcePath = string;
        this.dsIndex = n;
        this.arcIndex = n2;
        this.fillGraphCombo();
        this.constructUI();
        this.pack();
        Util.placeWindow(this);
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRrdGraph() {
        System.out.println("Creating graph...");
        try {
            RrdDef rrdDef;
            double[] dArray;
            long[] lArray;
            long l;
            long l2;
            String string;
            Object object;
            Object object2;
            RrdDb rrdDb = new RrdDb(this.sourcePath, true);
            try {
                object2 = rrdDb.getDatasource(this.dsIndex);
                object = rrdDb.getArchive(this.arcIndex);
                Robin robin = ((Archive)object).getRobin(this.dsIndex);
                string = ((Datasource)object2).getName();
                l2 = ((Archive)object).getStartTime();
                l = ((Archive)object).getEndTime();
                long l3 = ((Archive)object).getArcStep();
                int n = robin.getSize();
                lArray = new long[n];
                for (int i = 0; i < n; ++i) {
                    lArray[i] = l2 + (long)i * l3;
                }
                dArray = robin.getValues();
                rrdDef = rrdDb.getRrdDef();
            }
            finally {
                rrdDb.close();
            }
            object2 = new RrdGraphDef();
            ((RrdGraphDef)object2).setTimeSpan(l2, l);
            ((RrdGraphDef)object2).setImageFormat("png");
            ((RrdGraphDef)object2).setTitle(rrdDef.getDsDefs()[this.dsIndex].dump() + " " + rrdDef.getArcDefs()[this.arcIndex].dump());
            object = new LinearInterpolator(lArray, dArray);
            ((LinearInterpolator)object).setInterpolationMethod(1);
            ((RrdGraphDef)object2).datasource(string, (Plottable)object);
            ((RrdGraphDef)object2).area(string, this.color, string + "\\r");
            ((RrdGraphDef)object2).comment("START: " + new Date(l2 * 1000L) + "\\r");
            ((RrdGraphDef)object2).comment("END: " + new Date(l * 1000L) + "\\r");
            int n = this.graphPanel.getWidth();
            int n2 = this.graphPanel.getHeight();
            ((RrdGraphDef)object2).setWidth(n + this.deltaWidth);
            ((RrdGraphDef)object2).setHeight(n2 + this.deltaHeight);
            this.rrdGraph = new RrdGraph((RrdGraphDef)object2);
            if (this.deltaWidth == 0 && this.deltaHeight == 0) {
                RrdGraphInfo rrdGraphInfo = this.rrdGraph.getRrdGraphInfo();
                this.deltaWidth = this.graphPanel.getWidth() - rrdGraphInfo.getWidth();
                this.deltaHeight = this.graphPanel.getHeight() - rrdGraphInfo.getHeight();
                if (this.deltaWidth != 0 && this.deltaHeight != 0) {
                    this.createRrdGraph();
                }
            }
        }
        catch (Exception exception) {
            Util.error((Component)this, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillGraphCombo() {
        try {
            RrdDb rrdDb = new RrdDb(this.sourcePath, true);
            try {
                RrdDef rrdDef = rrdDb.getRrdDef();
                DsDef[] dsDefArray = rrdDef.getDsDefs();
                ArcDef[] arcDefArray = rrdDef.getArcDefs();
                GraphComboItem[] graphComboItemArray = new GraphComboItem[rrdDef.getDsCount() * rrdDef.getArcCount()];
                int n = -1;
                int n2 = 0;
                for (int i = 0; i < rrdDef.getDsCount(); ++i) {
                    for (int j = 0; j < rrdDef.getArcCount(); ++j) {
                        String string = dsDefArray[i].dump() + " " + arcDefArray[j].dump();
                        graphComboItemArray[n2] = new GraphComboItem(string, i, j);
                        if (i == this.dsIndex && j == this.arcIndex) {
                            n = n2;
                        }
                        ++n2;
                    }
                }
                this.graphCombo.setModel(new DefaultComboBoxModel<GraphComboItem>(graphComboItemArray));
                this.graphCombo.setSelectedIndex(n);
            }
            finally {
                rrdDb.close();
            }
        }
        catch (Exception exception) {
            Util.error((Component)this, exception);
        }
    }

    private void constructUI() {
        this.setTitle(new File(this.sourcePath).getName());
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)this.graphCombo, "North");
        this.graphPanel.setPreferredSize(new Dimension(400, 240));
        jPanel.add((Component)this.graphPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 0, 0));
        JButton jButton = new JButton("Change graph color");
        jPanel2.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.changeColor();
            }
        });
        JButton jButton2 = new JButton("Save graph");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.saveGraph();
            }
        });
        jPanel2.add(Box.createHorizontalStrut(3));
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "South");
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GraphFrame.this.closeWindow();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                GraphFrame.this.createRrdGraph();
                GraphFrame.this.graphPanel.repaint();
            }
        });
        this.graphCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    GraphComboItem graphComboItem = (GraphComboItem)itemEvent.getItem();
                    GraphFrame.this.dsIndex = graphComboItem.getDsIndex();
                    GraphFrame.this.arcIndex = graphComboItem.getArcIndex();
                    GraphFrame.this.createRrdGraph();
                    GraphFrame.this.graphPanel.repaint();
                }
            }
        });
    }

    private void closeWindow() {
        Util.dismissWindow(this);
    }

    private void changeColor() {
        final JColorChooser jColorChooser = new JColorChooser(this.color);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.color = jColorChooser.getColor();
                GraphFrame.this.createRrdGraph();
                GraphFrame.this.repaint();
            }
        };
        JColorChooser.createDialog(this, "Select color", true, jColorChooser, actionListener, null).setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveGraph() {
        JFileChooser jFileChooser = new JFileChooser();
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getAbsolutePath().toLowerCase().endsWith(".png");
            }

            @Override
            public String getDescription() {
                return "PNG images";
            }
        };
        jFileChooser.setFileFilter(fileFilter);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            try {
                String string;
                int n2;
                File file = jFileChooser.getSelectedFile();
                String string2 = file.getAbsolutePath();
                if (!string2.toLowerCase().endsWith(".png")) {
                    string2 = string2 + ".png";
                    file = new File(string2);
                }
                if (file.exists() && (n2 = JOptionPane.showConfirmDialog(this, string = "File [" + file.getName() + "] already exists. Do you want to overwrite it?", "File exists", 0)) == 1) {
                    return;
                }
                string = file.getAbsolutePath();
                byte[] byArray = this.rrdGraph.getRrdGraphInfo().getBytes();
                RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
                try {
                    randomAccessFile.write(byArray);
                }
                finally {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {
                Util.error((Component)this, "Could not save graph to file:\n" + iOException);
            }
        }
    }

    class GraphComboItem {
        private String description;
        private int dsIndex;
        private int arcIndex;

        GraphComboItem(String string, int n, int n2) {
            this.description = string;
            this.dsIndex = n;
            this.arcIndex = n2;
        }

        public String toString() {
            return this.description;
        }

        int getDsIndex() {
            return this.dsIndex;
        }

        int getArcIndex() {
            return this.arcIndex;
        }
    }

    final class GraphPanel
    extends JPanel {
        GraphPanel() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            if (GraphFrame.this.rrdGraph != null) {
                GraphFrame.this.rrdGraph.render(graphics);
            }
        }
    }
}

